unit MPEAnimationsFrame;

interface

// -----------------------------------------------------------------------------
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, 
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, Buttons,
  Math,
  MPEProject, MPEProcessMessage;

// -----------------------------------------------------------------------------
type
  TAnimationsFrame = class(TFrame)
    GroupBox1: TGroupBox;
    XAxisPanel: TPanel;
    GroupBox2: TGroupBox;
    YAxisPanel: TPanel;
    GroupBox3: TGroupBox;
    ZAxisPanel: TPanel;
    AnimationTimer: TTimer;
    GroupBox4: TGroupBox;
    AnimationTimelineTrackBar: TTrackBar;
    AnimationStopBtn: TSpeedButton;
    AnimationPlayBtn: TSpeedButton;
    AnimationStartBtn: TSpeedButton;
    AnimationFramesLabel: TLabel;
    GroupBox5: TGroupBox;
    Label1: TLabel;
    AnimationSpeedComboBox: TComboBox;
    Label2: TLabel;
    ReloadBtn: TButton;
    procedure AnimationTimerTimer(Sender: TObject);
    procedure AnimationTimelineTrackBarChange(Sender: TObject);
    procedure AnimationStopBtnClick(Sender: TObject);
    procedure AnimationPlayBtnClick(Sender: TObject);
    procedure AnimationStartBtnClick(Sender: TObject);
    procedure AnimationSpeedComboBoxChange(Sender: TObject);
    procedure ReloadBtnClick(Sender: TObject);
  private

  public
    // Metody
    procedure Paint;

    procedure LoadFromProject;

    // Tworzenie
    constructor Create(AOwner: TComponent); override;

  end;

// -----------------------------------------------------------------------------
var
  AnimationsFrame: TAnimationsFrame;

implementation

// -----------------------------------------------------------------------------
uses
  MPEMain;

{$R *.dfm}

// -----------------------------------------------------------------------------
procedure TAnimationsFrame.Paint;
var
  canvas: TCanvas;
begin

canvas := TCanvas.Create;

// X
canvas.Handle := GetDC(XAxisPanel.Handle);
Project.Animations.Draw(0, canvas, 1, 1, XAxisPanel.Width-2, XAxisPanel.Height-2);
ReleaseDC(XAxisPanel.Handle, canvas.Handle);

// Y
canvas.Handle := GetDC(YAxisPanel.Handle);
Project.Animations.Draw(1, canvas, 1, 1, YAxisPanel.Width-2, YAxisPanel.Height-2);
ReleaseDC(YAxisPanel.Handle, canvas.Handle);

// Z
canvas.Handle := GetDC(ZAxisPanel.Handle);
Project.Animations.Draw(2, canvas, 1, 1, ZAxisPanel.Width-2, ZAxisPanel.Height-2);
ReleaseDC(ZAxisPanel.Handle, canvas.Handle);

canvas.Free;

end;

// -----------------------------------------------------------------------------
procedure TAnimationsFrame.ReloadBtnClick(Sender: TObject);
begin

ShowProcessMessage(MainForm);

LoadFromProject;

HideProcessMessage;

end;

// -----------------------------------------------------------------------------
procedure TAnimationsFrame.LoadFromProject;
begin

// Odczytywanie klatek animacji
Project.Animations.ImportFromProjectDirectory;

// Skala czasu
AnimationStopBtnClick(Self);
AnimationTimelineTrackBar.Max := Max(0, Project.Animations.Count-1);
AnimationTimelineTrackBar.Position := 0;
AnimationTimelineTrackBarChange(Self);

end;

// -----------------------------------------------------------------------------
constructor TAnimationsFrame.Create(AOwner: TComponent);
begin

inherited Create(AOwner);

AnimationSpeedComboBoxChange(Self);

end;

// -----------------------------------------------------------------------------
procedure TAnimationsFrame.AnimationPlayBtnClick(Sender: TObject);
begin
AnimationPlayBtn.Enabled := False;
AnimationStopBtn.Enabled := True;
AnimationTimelineTrackBar.Enabled := False;
AnimationTimer.Enabled := True;
end;

// -----------------------------------------------------------------------------
procedure TAnimationsFrame.AnimationSpeedComboBoxChange(Sender: TObject);
begin
AnimationTimer.Interval := 1000 div StrToInt(AnimationSpeedComboBox.Text);
end;

// -----------------------------------------------------------------------------
procedure TAnimationsFrame.AnimationStartBtnClick(Sender: TObject);
begin
AnimationStopBtnClick(Sender);
AnimationTimelineTrackBar.Position := 0;
end;

// -----------------------------------------------------------------------------
procedure TAnimationsFrame.AnimationStopBtnClick(Sender: TObject);
begin
AnimationTimelineTrackBar.Enabled := True;
AnimationStopBtn.Enabled := False;
AnimationPlayBtn.Enabled := True;
AnimationTimer.Enabled := False;
end;

// -----------------------------------------------------------------------------
procedure TAnimationsFrame.AnimationTimelineTrackBarChange(Sender: TObject);
begin

// Klatka animacji
Project.Animations.Position := AnimationTimelineTrackBar.Position;

// Numer klatki
if AnimationTimelineTrackBar.Max > 0 then
  AnimationFramesLabel.Caption :=
    IntToStr(AnimationTimelineTrackBar.Position+1) + ' / ' +
    IntToStr(AnimationTimelineTrackBar.Max+1)
else
  AnimationFramesLabel.Caption := '0 / 0';

// Rysowanie
Paint;

end;

// -----------------------------------------------------------------------------
procedure TAnimationsFrame.AnimationTimerTimer(Sender: TObject);
begin

// Skala czasu
if AnimationTimelineTrackBar.Position < AnimationTimelineTrackBar.Max then
  AnimationTimelineTrackBar.Position := AnimationTimelineTrackBar.Position+1
else
  AnimationTimelineTrackBar.Position := 0;

end;

end.
