unit MPEExt;

interface

// -----------------------------------------------------------------------------
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  CommCtrl, StdCtrls, ImgList, Consts,
  Math;

// -----------------------------------------------------------------------------
type
  TDataColumn = record
    Name: String;
    Metric: String;
  end;

// -----------------------------------------------------------------------------
const
  // Ogolne
  VERSION: Byte = 2; // 1.0.2
  VERSION_NAME  = '1.0.2';
  FILE_VERSION: Byte = 0; // 1.0.0

  // Sciezki
  DATA_DIR = 'data\';
  ICONS_DIR = DATA_DIR + 'icons\';
  OTHERS_DIR = DATA_DIR + 'others\';

  // Interface
  ICONS_LIST: array[0..8] of String = (
    {0} 'file.ico',
    {1} 'folder.ico',
    {2} 'disc.ico',
    {3} 'options.ico',
    {4} 'book.ico',
    {5} 'graph.ico',
    {6} 'media.ico',
    {7} 'about.ico',
    {8} 'exit.ico'
    );

  GRAPH_IMAGE_WIDTH = 779;
  GRAPH_IMAGE_HEIGHT = 460;
  GRAPH_IMAGE_TOOLTIP_SPACE = 16;

  // INNE
  DEFAULT_INPUT_DATA_FILENAME = 'default_allopt.txt';
  DEFAULT_INPUT_DATA_COMPONENT_HINT_PREFIX = 'Default value: ';

  // Dane wejsciowe
  INPUT_DATA_FILENAME = 'allopt.txt';
  INPUT_DATA_BACKUP_FILENAME_PREFIX = 'backup_';
  INPUT_DATA_PARAM_CHAR = '-';
  INPUT_DATA_SIMNAME_PARAM_NAME = 'simName';
  INPUT_DATA_COMMENT_CHAR = '#';
  INPUT_DATA_DECIMAL_SEPARATOR = '.';
  INPUT_DATA_MULTIPLE_VALUES_SEPARATOR = ',';
  INPUT_DATA_COMPONENT_NAME_SURFIX = 'Cmp';

  // Dane wejsciowe materialowe
  MATERIAL_INPUT_DATA_FILEEXT = '.krn';
  MATERIAL_INPUT_DATA_BACKUP_FILENAME_PREFIX = 'backup_';
  MATERIAL_INPUT_DATA_COMMENT_CHAR = '#';
  MATERIAL_INPUT_DECIMAL_SEPARATOR = '.';
  MATERIAL_INPUT_DATA_COLUMNS_COUNT = 8;
  MATERIAL_INPUT_DATA_NONE_COLUMN = 255;
  MATERIAL_INPUT_DATA_COLUMNS: array[0..MATERIAL_INPUT_DATA_COLUMNS_COUNT-1] of TDataColumn = (
    (Name: 'theta'; Metric: 'rad'),
    (Name: 'phi'; Metric: 'rad'),
    (Name: 'K1'; Metric: 'J/m^3'),
    (Name: 'K2'; Metric: 'J/m^3'),
    (Name: 'Js'; Metric: 'T'),
    (Name: 'A'; Metric: 'J/m'),
    (Name: 'alpha'; Metric: ''),
    (Name: 'psi'; Metric: 'rad')
    );

  // Dane wyjsciowe
  OUTPUT_DATA_FILEEXT = '.log';
  OUTPUT_DATA_COMMENT_CHAR = '#';
  OUTPUT_DATA_DECIMAL_SEPARATOR = '.';
  OUTPUT_DATA_COLUMNS_COUNT = 19;
  OUTPUT_DATA_NONE_COLUMN = 255;
  OUTPUT_DATA_COLUMNS: array[0..OUTPUT_DATA_COLUMNS_COUNT-1] of TDataColumn = (
    (Name: 'eq'; Metric: ''),
    (Name: 'inp'; Metric: ''),
    (Name: 'time'; Metric: 'ns'),
    (Name: 'Hext'; Metric: 'kA/m'),
    (Name: 'Etot'; Metric: 'J/m^3'),
    (Name: 'J/Hext'; Metric: 'J/Javg'),
    (Name: 'Mx'; Metric: '1'),
    (Name: 'My'; Metric: '1'),
    (Name: 'Mz'; Metric: '1'),
    (Name: '|M|'; Metric: '1'),
    (Name: 'Edem'; Metric: 'J/m^3'),
    (Name: 'Eanionly'; Metric: 'J/m^3'),
    (Name: 'Eext'; Metric: 'J/m^3'),
    (Name: 'Eexchonly'; Metric: 'J/m^3'),
    (Name: 'devNorm'; Metric: '1'),
    (Name: 'mx|dM/dt|'; Metric: '1'),
    (Name: 'timestep'; Metric: 'ns'),
    (Name: 'tCPU'; Metric: 's'),
    (Name: 'CPUtstep'; Metric: 's')
    );

  // Dane wyjsciowe graficzne
  GRAPHICS_OUTPUT_DATA_FILEEXT = '.png';

// -----------------------------------------------------------------------------
procedure AddIconTo32BitImageList(ImageList: TImageList; const FileName: String);
function BoundsRange(Value, Min, Max: Integer): Integer;
procedure ConvertTo32BitImageList(ImageList: TImageList);
function GetColumnFullName(const ColumnsArray: array of TDataColumn; Index: Byte): String;
function Split(const Separator, Source: String;
  var Target: array of String): Integer;
procedure SplitParamValue(const S: String; var Param, Value: String);
function StepRange(Value, Min, Max: Integer): Integer; overload;
function StepRange(Value, Min, Max: Single): Single; overload;
procedure StripLine(var S: String; CommentChar: Char);
function StrToFloatEx(const S: String; Separator: Char): Double;
function StrToStrEx(const S: String; Separator: Char): String;
function StrToStrEx2(const S: String; Separator: Char): String;

implementation

// -----------------------------------------------------------------------------
procedure AddIconTo32BitImageList(ImageList: TImageList; const FileName: String);
var
  icon: TIcon;
  stream: TFileStream;
begin

icon := TIcon.Create;
stream := TFileStream.Create(FileName, fmOpenRead);
icon.LoadFromStream(stream);
ImageList.AddIcon(icon);
icon.Free;
stream.Free;

end;

// -----------------------------------------------------------------------------
function BoundsRange(Value, Min, Max: Integer): Integer;
var
  range: Integer;
begin

range := Max-Min+1;

if range <= 0 then
  Result := Min
else if Value < Min then
  Result := Value + range*Ceil((Min-Value)/range)
else if Value > Max then
  Result := Value - range*Ceil((Value-Max)/range)
else
  Result := Value;

end;

// -----------------------------------------------------------------------------
procedure ConvertTo32BitImageList(ImageList: TImageList);
const
  MASK: array[Boolean] of Longint = (0, ILC_MASK);
var
  templist: TImageList;
begin

if Assigned(ImageList) then
  begin
  templist := TImageList.Create(nil);
  try
    templist.Assign(ImageList);
    with ImageList do
      begin
      Handle := ImageList_Create(Width, Height, ILC_COLOR32 or MASK[Masked], 0, AllocBy);
      if not HandleAllocated then
        raise EInvalidOperation.Create(SInvalidImageList);
      end;
    Imagelist.AddImages(templist);
  finally
    FreeAndNil(templist);
  end;
  end;

end;

// -----------------------------------------------------------------------------
function GetColumnFullName(const ColumnsArray: array of TDataColumn; Index: Byte): String;
begin

Result := ColumnsArray[Index].Name;

if ColumnsArray[Index].Metric <> '' then
  Result := Result + ' [' + ColumnsArray[Index].Metric + ']';

end;

// -----------------------------------------------------------------------------
function Split(const Separator, Source: String;
  var Target: array of String): Integer;
var
  i: Integer;
  s: String;
begin

Result := 0;
s := Source;

while (Pos(Separator, s) <> 0) and (Length(Target) > Result+1) do
  begin

  // Pozycja separatora w ciagu znakow
  i := Pos(Separator, s);

  // Przypisanie elementu do tablicy
  Target[Result] := Copy(s, 1, i-1);
  s := Copy(s, i+Length(Separator), Length(s)-(i+Length(Separator))+1);

  // Licznik kolejnego elementu tablicy
  Inc(Result);

  end;

// Zwrocenie pozostalych znakow w ostatniej dostepnej komorce tablicy
Target[Result] := s;
Inc(Result);

end;

// -----------------------------------------------------------------------------
procedure SplitParamValue(const S: String; var Param, Value: String);
var
  i: Integer;
begin

// Detekcja separatora parametru od wartosci
i := Pos(' ', S);

// Parametr, wartosc
if i > 0 then
  begin
  Param := Copy(S, 2, i-2);
  Value := Copy(S, i+1, Length(S)-i);
  end
else
  begin
  Param := Copy(S, 2, Length(S)-1);
  Value := '';
  end;

end;

// -----------------------------------------------------------------------------
function StepRange(Value, Min, Max: Integer): Integer;
begin

if Value < Min then
  Result := Min
else if Value > Max then
  Result := Max
else
  Result := Value;

end;

// -----------------------------------------------------------------------------
function StepRange(Value, Min, Max: Single): Single;
begin

if Value < Min then
  Result := Min
else if Value > Max then
  Result := Max
else
  Result := Value;

end;

// -----------------------------------------------------------------------------
procedure StripLine(var S: String; CommentChar: Char);
var
  i: Integer;
begin

// Usuwanie komentarza linii
i := Pos(CommentChar, S);
if i > 0 then
  S := Copy(S, 1, i-1);

// Usuwanie spacji na poczatku linii
while (Length(S) > 0) and (S[1] = ' ') do
  S := Copy(S, 2, Length(S)-1);

// Usuwanie spacji na koncu linii
while (Length(S) > 0) and (S[Length(S)] = ' ') do
  S := Copy(S, 1, Length(S)-1);

// Usuwanie wielokrotnych znakow spacji
while Pos('  ', S) > 0 do
  S := StringReplace(S, '  ', ' ', [rfReplaceAll]);

end;

// -----------------------------------------------------------------------------
function StrToFloatEx(const S: String; Separator: Char): Double;
begin
Result := StrToFloat(StrToStrEx(S, Separator));
end;

// -----------------------------------------------------------------------------
function StrToStrEx(const S: String; Separator: Char): String;
begin
Result := StringReplace(S, Separator, DecimalSeparator, []);
end;

// -----------------------------------------------------------------------------
function StrToStrEx2(const S: String; Separator: Char): String;
begin
Result := StringReplace(S, DecimalSeparator, Separator, []);
end;

end.
