unit MPEGraphsFrame;

interface

// -----------------------------------------------------------------------------
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, 
  Dialogs, StdCtrls, ComCtrls, ExtCtrls,
  MPEExt, MPEGraph, MPEGraphEdit, MPEOptions, MPEProject, MPEToolTip;

// -----------------------------------------------------------------------------
type
  TGraphsFrame = class(TFrame)
    GroupBox1: TGroupBox;
    GraphsTabControl: TTabControl;
    AddNewGraphBtn: TButton;
    GroupBox2: TGroupBox;
    ConfigureGraphBtn: TButton;
    GraphPanel: TPanel;
    GraphImage: TImage;
    DeleteGraphBtn: TButton;
    GraphCoordsLabel: TLabel;
    ExportGraphBtn: TButton;
    GraphExportSaveDialog: TSaveDialog;
    GraphRepaintTimeLabel: TLabel;
    procedure AddNewGraphBtnClick(Sender: TObject);
    procedure GraphsTabControlChange(Sender: TObject);
    procedure DeleteGraphBtnClick(Sender: TObject);
    procedure ConfigureGraphBtnClick(Sender: TObject);
    procedure GraphImageMouseEnter(Sender: TObject);
    procedure GraphImageMouseLeave(Sender: TObject);
    procedure GraphImageMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure GraphImageMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ExportGraphBtnClick(Sender: TObject);
  private
  public
    // Metody
    procedure RepaintGraph(Index: Integer);
    procedure SwitchGraph(Index: Integer);
    procedure EditGraph(Index: Integer);

    procedure LoadGraphsFromProject;

    procedure LoadFromProject;
    procedure SaveToProject;

    // Tworzenie
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;       

  end;

// -----------------------------------------------------------------------------
var
  GraphsFrame: TGraphsFrame;

implementation

uses
  MPEMain;

{$R *.dfm}

// -----------------------------------------------------------------------------
procedure TGraphsFrame.RepaintGraph(Index: Integer);
begin
Project.Graphs.Graphs[Index].Samples := OptionsForm.GraphsQualityComboBox.ItemIndex+1;
Project.Graphs.Graphs[Index].Repaint;
end;

// -----------------------------------------------------------------------------
procedure TGraphsFrame.SwitchGraph(Index: Integer);
begin
GraphsTabControl.TabIndex := Index;
GraphImage.Picture.Bitmap := Project.Graphs.Graphs[GraphsTabControl.TabIndex].Bitmap;
GraphRepaintTimeLabel.Caption := IntToStr(Project.Graphs.Graphs[GraphsTabControl.TabIndex].RepaintTime) + ' ms';
end;

// -----------------------------------------------------------------------------
procedure TGraphsFrame.EditGraph(Index: Integer);
begin

if (Index >= 0) and (Index <= GraphsTabControl.Tabs.Count-1) then
  GraphsTabControl.Tabs.Strings[Index] := Project.Graphs.Graphs[Index].Name
else
  GraphsTabControl.Tabs.Add(Project.Graphs.Graphs[Index].Name);

RepaintGraph(Index);

end;

// -----------------------------------------------------------------------------
procedure TGraphsFrame.ExportGraphBtnClick(Sender: TObject);
begin

if GraphExportSaveDialog.Execute then
  Project.Graphs.Graphs[GraphsTabControl.TabIndex].ExportToFile(GraphExportSaveDialog.FileName);

end;

// -----------------------------------------------------------------------------
procedure TGraphsFrame.LoadGraphsFromProject;
var
  i: Integer;
begin

GraphsTabControl.Tabs.Clear;

if Project.Graphs.Count > 0 then
  begin

  for i := 0 to Project.Graphs.Count-1 do
    EditGraph(i);

  SwitchGraph(0);
  GraphsTabControl.Visible := True;
  
  end
else
  GraphsTabControl.Visible := False;

end;

// -----------------------------------------------------------------------------
procedure TGraphsFrame.LoadFromProject;
begin

// Dane
LoadGraphsFromProject;

end;

// -----------------------------------------------------------------------------
procedure TGraphsFrame.SaveToProject;
begin

// Dane

end;

// -----------------------------------------------------------------------------
constructor TGraphsFrame.Create(AOwner: TComponent);
begin

inherited Create(AOwner);

// Podpowiedz
ToolTipForm := TToolTipForm.Create(GraphPanel);
ToolTipForm.Parent := TForm(GraphPanel);

end;

// -----------------------------------------------------------------------------
destructor TGraphsFrame.Destroy;
begin

// Podpowiedz
ToolTipForm.Free;

inherited Destroy;

end;

// -----------------------------------------------------------------------------
procedure TGraphsFrame.ConfigureGraphBtnClick(Sender: TObject);
var
  index: Integer;
begin

index := GraphsTabControl.TabIndex;

if index <> -1 then
  begin

  GraphEditForm := TGraphEditForm.Create(Self);
  GraphEditForm.LoadFromProject(index);

  if GraphEditForm.ShowModal = mrOK then
    begin
    GraphEditForm.SaveToProject(index);
    Project.Edited;
    EditGraph(Index);
    SwitchGraph(Index);
    end;

  GraphEditForm.Free;
  GraphEditForm := nil;

  end;

end;

// -----------------------------------------------------------------------------
procedure TGraphsFrame.DeleteGraphBtnClick(Sender: TObject);
var
  index: Integer;
begin

index := GraphsTabControl.TabIndex;

if index <> -1 then
  if MessageBox(Handle, PChar('Do you really want to remove ' + Project.Graphs.Graphs[index].Name + ' graph?'), PChar(MainForm.Caption), MB_ICONQUESTION or MB_YESNO) = IDYES then
    begin

    Project.Graphs.DeleteGraph(index);
    Project.Edited;
    GraphsTabControl.Tabs.Delete(index);

    if Project.Graphs.Count > 0 then
      SwitchGraph(StepRange(index, 0, Project.Graphs.Count-1))
    else
      GraphsTabControl.Visible := False;

    end;

end;

// -----------------------------------------------------------------------------
procedure TGraphsFrame.GraphImageMouseEnter(Sender: TObject);
begin
//ToolTipForm.Show;
end;

// -----------------------------------------------------------------------------
procedure TGraphsFrame.GraphImageMouseLeave(Sender: TObject);
begin
//ToolTipForm.Hide;
GraphCoordsLabel.Caption := '';
// TODO: Usunac
end;

// -----------------------------------------------------------------------------
procedure TGraphsFrame.GraphImageMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
var
  dx, dy: Double;
begin
{
// X
if X+GRAPH_IMAGE_TOOLTIP_SPACE < GraphImage.Width-ToolTipForm.Width then
  ToolTipForm.Left := X+GRAPH_IMAGE_TOOLTIP_SPACE
else
  ToolTipForm.Left := X-(GRAPH_IMAGE_TOOLTIP_SPACE+ToolTipForm.Width);

// Y
if Y+GRAPH_IMAGE_TOOLTIP_SPACE < GraphImage.Height-ToolTipForm.Height then
  ToolTipForm.Top := Y+GRAPH_IMAGE_TOOLTIP_SPACE
else
  ToolTipForm.Top := Y-(GRAPH_IMAGE_TOOLTIP_SPACE+ToolTipForm.Height);

// Wspolzedne
Project.Graphs.Graphs[GraphsTabControl.TabIndex].PixelsToPoint(X, Y, dx, dy);

ToolTipForm.ToolTipPanel.Caption :=
  FloatToStrF(dx, ffGeneral, 3, 2) +
  ' x ' +
  FloatToStrF(dy, ffGeneral, 3, 2);    }

Project.Graphs.Graphs[GraphsTabControl.TabIndex].PixelsToPoint(X, Y, dx, dy);

GraphCoordsLabel.Caption :=
  FloatToStrF(dx, ffGeneral, 3, 2) +
  ' x ' +
  FloatToStrF(dy, ffGeneral, 3, 2);
  // TODO: Usunac

end;

// -----------------------------------------------------------------------------
procedure TGraphsFrame.GraphImageMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  index, f: Integer;
  graph: TMPEGraph;
  dx, dy, delta: Double;
begin

// Wykres
index := GraphsTabControl.TabIndex;
graph := Project.Graphs.Graphs[index];

// Wspolzedne
Project.Graphs.Graphs[GraphsTabControl.TabIndex].PixelsToPoint(X, Y, dx, dy);

// Rodzaj akcji
case Button of
  mbLeft:  f := 4;
  mbRight: f := 1;
  else     f := 2;
end;

// Os X
graph.AxisXAutomatic := False;
delta := (graph.AxisXMax-graph.AxisXMin) / f;
graph.AxisXMin := dx - delta;
graph.AxisXMax := dx + delta;

// Os Y
graph.AxisYAutomatic := False;
delta := (graph.AxisYMax-graph.AxisYMin) / f;
graph.AxisYMin := dy - delta;
graph.AxisYMax := dy + delta;

// Odswierzenie
EditGraph(index);
SwitchGraph(index);

end;

// -----------------------------------------------------------------------------
procedure TGraphsFrame.GraphsTabControlChange(Sender: TObject);
begin

if GraphsTabControl.TabIndex <> -1 then
  SwitchGraph(GraphsTabControl.TabIndex);

end;

// -----------------------------------------------------------------------------
procedure TGraphsFrame.AddNewGraphBtnClick(Sender: TObject);
begin

GraphEditForm := TGraphEditForm.Create(Self);

if GraphEditForm.ShowModal = mrOK then
  begin
  GraphEditForm.SaveToProject;
  Project.Edited;
  EditGraph(Project.Graphs.Count-1);
  SwitchGraph(Project.Graphs.Count-1);
  GraphsTabControl.Visible := True;
  end;

GraphEditForm.Free;
GraphEditForm := nil;

end;

end.
