unit MPEOptions;

interface

// -----------------------------------------------------------------------------
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls,
  Registry;

// -----------------------------------------------------------------------------
type
  TOptionsForm = class(TForm)
    StatusBar: TStatusBar;
    PageControl: TPageControl;
    TabSheet1: TTabSheet;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    GraphsQualityComboBox: TComboBox;
    CancelBtn: TButton;
    OKBtn: TButton;
    Label2: TLabel;
    TabSheet2: TTabSheet;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    MagParPathEdit: TEdit;
    MagParPathBrowseBtn: TButton;
    MagParPathOpenDialog: TOpenDialog;
    procedure MagParPathBrowseBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
  public
    // Metody
    procedure LoadFromRegistry;
    procedure SaveToRegistry;

  end;

// -----------------------------------------------------------------------------
var
  OptionsForm: TOptionsForm;

implementation

{$R *.dfm}

// -----------------------------------------------------------------------------
procedure TOptionsForm.FormShow(Sender: TObject);
begin
PageControl.ActivePageIndex := 0;
end;

// -----------------------------------------------------------------------------
procedure TOptionsForm.LoadFromRegistry;
var
  reg: TRegistry;
begin

// Odczyt ustawien
reg := TRegistry.Create;
reg.RootKey := HKEY_CURRENT_USER;

if reg.OpenKey('Software\BBProject\MagParExt', False) then
  begin
  MagParPathEdit.Text := reg.ReadString('MagParPath');
  GraphsQualityComboBox.ItemIndex := reg.ReadInteger('GraphsQuality');
  reg.CloseKey;
  end;

reg.Free;

end;

// -----------------------------------------------------------------------------
procedure TOptionsForm.MagParPathBrowseBtnClick(Sender: TObject);
begin
                  
if MagParPathOpenDialog.Execute then
  MagParPathEdit.Text := MagParPathOpenDialog.FileName;

end;

// -----------------------------------------------------------------------------
procedure TOptionsForm.SaveToRegistry;
var
  reg: TRegistry;
begin

// Zapis ustawien
reg := TRegistry.Create;
reg.RootKey := HKEY_CURRENT_USER;

if reg.OpenKey('Software\BBProject\MagParExt', True) then
  begin
  reg.WriteString('MagParPath', MagParPathEdit.Text);
  reg.WriteInteger('GraphsQuality', GraphsQualityComboBox.ItemIndex);
  reg.CloseKey;
  end;

reg.Free;

end;

end.
