unit MPEProcessMessage;

interface

// -----------------------------------------------------------------------------
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls;

// -----------------------------------------------------------------------------
type
  TProcessMessageForm = class(TForm)
    GroupBox1: TGroupBox;
    ProcessMessagePanel: TPanel;
    StatusBar: TStatusBar;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
  public
  end;

// -----------------------------------------------------------------------------
var
  ProcessMessageForm: TProcessMessageForm;

// -----------------------------------------------------------------------------
procedure ShowProcessMessage(Form: TForm; const ProcessMessage: String = 'Please wait...');
procedure HideProcessMessage;

implementation

{$R *.dfm}

// -----------------------------------------------------------------------------
procedure ShowProcessMessage(Form: TForm; const ProcessMessage: String = 'Please wait...');
begin

Form.Enabled := False;

ProcessMessageForm := TProcessMessageForm.Create(Form);
ProcessMessageForm.ProcessMessagePanel.Caption := ProcessMessage;
ProcessMessageForm.Show;

Application.ProcessMessages;

end;

// -----------------------------------------------------------------------------
procedure HideProcessMessage;
begin

ProcessMessageForm.Close;

TForm(ProcessMessageForm.Owner).Enabled := True;

ProcessMessageForm.Free;
ProcessMessageForm := nil;

end;

// -----------------------------------------------------------------------------
procedure TProcessMessageForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
Action := caNone;
end;

end.
