unit MPEProjectFrame;

interface

// -----------------------------------------------------------------------------
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, 
  Dialogs, StdCtrls, ComCtrls, FileCtrl, ShellApi, ExtCtrls,
  MPEExt, MPEOptions, MPEOutputDataPreview, MPEProcessMessage, MPEProject,
  MPESimulationEdit;

// -----------------------------------------------------------------------------
type
  TProjectFrame = class(TFrame)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    NameEdit: TEdit;
    Label2: TLabel;
    CommentMemo: TMemo;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    OutputDataImportBtn: TButton;
    OutputDataImportOpenDialog: TOpenDialog;
    SimulationConfigureBtn: TButton;
    SimulationRunBtn: TButton;
    GroupBox4: TGroupBox;
    Label4: TLabel;
    PathEdit: TEdit;
    GroupBox5: TGroupBox;
    MaterialPropertiesConfigureBtn: TButton;
    PathBrowseBtn: TButton;
    OutputDataLoadFromProjectBtn: TButton;
    MagParActiveTimer: TTimer;
    Label3: TLabel;
    SimulationStatusLabel: TLabel;
    SimulationStatusTimer: TTimer;
    SimulationStatusProgressBar: TProgressBar;
    Label5: TLabel;
    SimulationTimeLabel: TLabel;
    Label6: TLabel;
    OutputDataRowsCountLabel: TLabel;
    OutputDataPreviewBtn: TButton;
    procedure OutputDataImportBtnClick(Sender: TObject);
    procedure SimulationConfigureBtnClick(Sender: TObject);
    procedure PathBrowseBtnClick(Sender: TObject);
    procedure OutputDataLoadFromProjectBtnClick(Sender: TObject);
    procedure SimulationRunBtnClick(Sender: TObject);
    procedure MagParActiveTimerTimer(Sender: TObject);
    procedure SimulationStatusTimerTimer(Sender: TObject);
    procedure OutputDataPreviewBtnClick(Sender: TObject);
    procedure MaterialPropertiesConfigureBtnClick(Sender: TObject);
    procedure NameEditChange(Sender: TObject);
    procedure CommentMemoChange(Sender: TObject);
  private
    // Zmienne
    MagParActive: Boolean;
    MagParActiveTime: Cardinal;

  public
    // Metody
    procedure LoadPathFromProject;
    procedure LoadOutputDataFromProject;

    procedure LoadFromProject;
    procedure SaveToProject;

    // Tworzenie
    constructor Create(AOwner: TComponent); override;

  end;

// -----------------------------------------------------------------------------
var
  ProjectFrame: TProjectFrame;

implementation

// -----------------------------------------------------------------------------
uses
  MPEMain,
  MPEGraphsFrame,
  MPEAnimationsFrame,
  MPEMaterialProperties;

{$R *.dfm}

// -----------------------------------------------------------------------------
procedure TProjectFrame.LoadPathFromProject;
var
  bool: Boolean;
begin

// Sciezka projektu
PathEdit.Text := Project.Path;

// Aktywne przyciski
bool := DirectoryExists(Project.Path);
SimulationRunBtn.Enabled := bool;
SimulationConfigureBtn.Enabled := bool;
MaterialPropertiesConfigureBtn.Enabled := bool;
OutputDataLoadFromProjectBtn.Enabled := bool;

end;

// -----------------------------------------------------------------------------
procedure TProjectFrame.LoadOutputDataFromProject;
begin
OutputDataRowsCountLabel.Caption := IntToStr(Project.OutputData.Count);
OutputDataPreviewBtn.Enabled := (Project.OutputData.Count > 0);
end;

// -----------------------------------------------------------------------------
procedure TProjectFrame.LoadFromProject;
begin

// Dane
NameEdit.Text := Project.Name;
CommentMemo.Text := Project.Comment;

LoadPathFromProject;
LoadOutputDataFromProject;

end;

// -----------------------------------------------------------------------------
procedure TProjectFrame.SaveToProject;
begin

// Dane
Project.Name := NameEdit.Text;
Project.Comment := CommentMemo.Text;
Project.Path := PathEdit.Text;

end;

// -----------------------------------------------------------------------------
procedure TProjectFrame.MagParActiveTimerTimer(Sender: TObject);
var
  active: Boolean;
begin

// Aktywna symulacja MagPar
active := (
  (OptionsForm.MagParPathEdit.Text <> '') and
  (FindWindow(nil, PChar(OptionsForm.MagParPathEdit.Text)) <> 0)
  );

// Status
if MagParActive <> active then
  if active then
    begin
    SimulationStatusLabel.Caption := 'Active';
    SimulationStatusProgressBar.Position := 0;
    SimulationStatusProgressBar.Visible := True;
    MagParActiveTime := 0;
    end
  else
    begin
    SimulationStatusLabel.Caption := 'Inactive';
    SimulationStatusProgressBar.Visible := False;
    end;

// Czas symulacji
if active then
  begin
  Inc(MagParActiveTime);
  SimulationTimeLabel.Caption := IntToStr(MagParActiveTime*MagParActiveTimer.Interval div 1000) + ' sec.';
  end;

// Zmienna
MagParActive := active;

end;

// -----------------------------------------------------------------------------
procedure TProjectFrame.MaterialPropertiesConfigureBtnClick(Sender: TObject);
var
  filename: String;
begin

filename := Project.SimName + MATERIAL_INPUT_DATA_FILEEXT;

if FileExists(Project.Path + filename) then
  begin

  MaterialPropertiesForm := TMaterialPropertiesForm.Create(Self);
  MaterialPropertiesForm.LoadFromFile(Project.Path + filename);

  if MaterialPropertiesForm.ShowModal = mrOK then
    begin
    MaterialPropertiesForm.SaveToFile(Project.Path + filename);
    end;

  MaterialPropertiesForm.Free;
  MaterialPropertiesForm := nil;

  end
else
  MessageBox(Handle, PChar('File ' + filename + ' not found in project directory!'), PChar(MainForm.Caption), MB_ICONERROR or MB_OK);;

end;

// -----------------------------------------------------------------------------
procedure TProjectFrame.NameEditChange(Sender: TObject);
begin
Project.Edited;
end;

// -----------------------------------------------------------------------------
procedure TProjectFrame.SimulationConfigureBtnClick(Sender: TObject);
begin

if FileExists(Project.Path + INPUT_DATA_FILENAME) then
  begin

  ShowProcessMessage(MainForm);

  SimulationEditForm := TSimulationEditForm.Create(Self);
  SimulationEditForm.LoadFromFile(Project.Path + INPUT_DATA_FILENAME);

  HideProcessMessage;

  if SimulationEditForm.ShowModal = mrOK then
    begin
    ShowProcessMessage(MainForm);
    SimulationEditForm.SaveToFile(Project.Path + INPUT_DATA_FILENAME);
    HideProcessMessage;
    end;

  SimulationEditForm.Free;
  SimulationEditForm := nil;

  end
else
  MessageBox(Handle, 'File ' + INPUT_DATA_FILENAME + ' not found in project directory!', PChar(MainForm.Caption), MB_ICONERROR or MB_OK);

end;

// -----------------------------------------------------------------------------
procedure TProjectFrame.SimulationRunBtnClick(Sender: TObject);
var
  filename: String;
begin

if FileExists(Project.Path + INPUT_DATA_FILENAME) then
  begin

  if OptionsForm.MagParPathEdit.Text = '' then
    MessageBox(Handle, 'Can''t run simulation. MagPar application file is not set in options!', PChar(MainForm.Caption), MB_ICONERROR or MB_OK)
  else if FileExists(OptionsForm.MagParPathEdit.Text) then
    begin

    if (not MagParActive) or (MessageBox(Handle, 'Simulation process is active. Do you want to run another one?', PChar(MainForm.Caption), MB_ICONQUESTION or MB_YESNO) = IDYES) then
      begin

      // Kasowanie istniejaceo pliku wynikowego
      filename := Project.Path + Project.SimName + OUTPUT_DATA_FILEEXT;
      if FileExists(filename) then
        DeleteFile(filename);

      // Uruchamianie symulacji
      ShellExecute(Handle, '', PChar(OptionsForm.MagParPathEdit.Text), '', PChar(Project.Path), SW_SHOWMINIMIZED);

      end;

    end
  else
    MessageBox(Handle, PChar('Can''t run simulation. MagPar application file ' + OptionsForm.MagParPathEdit.Text + ' not found!'), PChar(MainForm.Caption), MB_ICONERROR or MB_OK);

  end
else
  MessageBox(Handle, 'Can''t run simulation. File ' + INPUT_DATA_FILENAME + ' not found in project directory!', PChar(MainForm.Caption), MB_ICONERROR or MB_OK);

end;

// -----------------------------------------------------------------------------
procedure TProjectFrame.SimulationStatusTimerTimer(Sender: TObject);
begin

if SimulationStatusProgressBar.Position < SimulationStatusProgressBar.Max then
  SimulationStatusProgressBar.StepIt
else
  SimulationStatusProgressBar.Position := 0;
  
end;

// -----------------------------------------------------------------------------
procedure TProjectFrame.OutputDataPreviewBtnClick(Sender: TObject);
begin

ShowProcessMessage(MainForm);

OutputDataPreviewForm := TOutputDataPreviewForm.Create(Self);
OutputDataPreviewForm.LoadFromProject;

HideProcessMessage;

if OutputDataPreviewForm.ShowModal = mrOK then
  begin
  end;

if Project.OutputData.Count >= 250 then
  ShowProcessMessage(MainForm);

OutputDataPreviewForm.Free;
OutputDataPreviewForm := nil;

if Project.OutputData.Count >= 250 then
  HideProcessMessage;

end;

// -----------------------------------------------------------------------------
procedure TProjectFrame.CommentMemoChange(Sender: TObject);
begin
Project.Edited;
end;

// -----------------------------------------------------------------------------
constructor TProjectFrame.Create(AOwner: TComponent);
begin

inherited Create(AOwner);

// Zmienne
MagParActive := False;
MagParActiveTime := 0;

end;

// -----------------------------------------------------------------------------
procedure TProjectFrame.OutputDataImportBtnClick(Sender: TObject);
begin

if DirectoryExists(Project.Path) then
  OutputDataImportOpenDialog.InitialDir := Project.Path
else
  OutputDataImportOpenDialog.InitialDir := '';

if OutputDataImportOpenDialog.Execute then
  begin

  ShowProcessMessage(MainForm);

  // Importowanie danych
  Project.OutputData.ImportFromFile(OutputDataImportOpenDialog.FileName);
  Project.Edited;

  // Wyswietlanie danych
  LoadOutputDataFromProject;

  HideProcessMessage;

  end;

end;

// -----------------------------------------------------------------------------
procedure TProjectFrame.OutputDataLoadFromProjectBtnClick(Sender: TObject);
var
  filename: String;
begin

filename := Project.SimName + OUTPUT_DATA_FILEEXT;

if FileExists(Project.Path + filename) then
  begin

  ShowProcessMessage(MainForm);
                        
  // Importowanie danych
  Project.OutputData.ImportFromFile(Project.Path + filename);
  Project.Edited;

  // Wyswietlanie danych
  LoadOutputDataFromProject;

  HideProcessMessage;
  
  end
else
  MessageBox(Handle, PChar('File ' + filename + ' not found in project directory!'), PChar(MainForm.Caption), MB_ICONERROR or MB_OK);;

end;

// -----------------------------------------------------------------------------
procedure TProjectFrame.PathBrowseBtnClick(Sender: TObject);
var
  dir: string;
begin

dir := PathEdit.Text;

if SelectDirectory('Select project directory:', '', dir, [sdNewFolder, sdNewUI, sdValidateDir], self) then
  begin

  if dir[Length(dir)] <> '\' then
    dir := dir + '\';

  Project.Path := dir;

  LoadPathFromProject;
  AnimationsFrame.LoadFromProject;
  Project.Edited;

  end;

end;

end.
