unit Complex;

      {*********************************************************}
      {***   COMPLEX UNIT for Delphi - Types and Functions   ***}
      {***   Autor : Natalia Walkowicz, styczen 2004         ***}
      {*********************************************************}

interface

uses Math;

type TComplex = Record
          Re : Extended;
          Im : Extended;
end;

function  AddCplx (Liczba1, Liczba2 : TComplex) : TComplex;
function  DifCplx (Liczba1, Liczba2 : TComplex) : TComplex;
function  MulCplx (Liczba1, Liczba2 : TComplex) : TComplex;
function  DivCplx (Liczba1, Liczba2 : TComplex) : TComplex;
function  PowCplx (Liczba1, Liczba2 : TComplex) : TComplex;
function  ExpCplx (Liczba : TComplex) : TComplex;
function  NegCplx (Liczba : TComplex) : TComplex;
function  AbsCplx (Liczba : TComplex) : Extended;
function  PhaseCplx  (Liczba : TComplex) : Extended;
function  RealToCplx (Real , Imag : Extended) : TComplex;
function  Signum (Time: Extended): Extended;
function  ZeroCplx : TComplex;

implementation

function Signum(Time: Extended): Extended;
begin
     if Time=0 then
        Result:=0
     else
        Result:=Time/Abs(Time);
end;

function ZeroCplx : TComplex;
begin
     Result.Re:=0;
     Result.Im:=0;
end;

function AddCplx(Liczba1, Liczba2 : TComplex) : TComplex;
begin
     Result.Re:=Liczba1.Re+Liczba2.Re;
     Result.Im:=Liczba1.Im+Liczba2.Im;
end;

function DifCplx(Liczba1, Liczba2 : TComplex) : TComplex;
begin
     Result.Re:=Liczba1.Re-Liczba2.Re;
     Result.Im:=Liczba1.Im-Liczba2.Im;
end;

function MulCplx(Liczba1, Liczba2 : TComplex) : TComplex;
var Zp : TComplex;
begin
     Zp.Re:=Liczba1.Re*Liczba2.Re+Liczba1.Im*Liczba2.Im;
     Zp.Im:=Liczba1.Re*Liczba2.Im+Liczba1.Im*Liczba2.Re;

     Result:=Zp;
end;

function DivCplx(Liczba1, Liczba2 : TComplex) : TComplex;
var c : Extended;
    z : TComplex;
begin
     c:=Liczba2.Re*Liczba2.Re+Liczba2.Im*Liczba2.Im;

     if c<>0 then
     begin
          z.Re:=(Liczba1.Re*Liczba2.Re-Liczba1.Im*Liczba2.Im)/c;
          z.Im:=(Liczba1.Re*Liczba2.Im+Liczba1.Im*Liczba2.Re)/c;
     end
     else
     begin
          z.Re:=0;
          z.Im:=0;
     end;

     Result:=z;
end;

function PowCplx(Liczba1, Liczba2 : TComplex) : TComplex;
var fi  : Extended;
    a,m : TComplex;
begin
     if AbsCplx(Liczba1)<>0 then
     begin
          fi:=ArcCos(Liczba1.Re/AbsCplx(Liczba1));
          a.Re:=Cos(fi*Liczba2.Re);
          a.Im:=Sin(fi*Liczba2.Re);
          m.Re:=Power(AbsCplx(Liczba1),Liczba2.Re);
          m.Im:=0;
     end
     else
     begin
          a.Re:=0;
          a.Im:=0;
          m.Re:=0;
          m.Im:=0;
     end;

     Result:=MulCplx(a,m);
end;

function ExpCplx(Liczba : TComplex) : TComplex;
var z1, z2, z3 : TComplex;
begin
     z1.Re:=exp(Liczba.Re);  z1.Im:=0;
     z2.Re:=cos(Liczba.Im);  z2.Im:=sin(Liczba.Im);

     if Liczba.Im>=0 then
        z3:=MulCplx(z1,z2)
     else
        z3:=DivCplx(z1,z2);

     Result:=z3;
end;

function AbsCplx(Liczba : TComplex) : Extended;
begin
     Result:=sqrt(Liczba.Re*Liczba.Re+Liczba.Im*Liczba.Im);
end;

function NegCplx(Liczba : TComplex) : TComplex;
begin
     Result.Re:=-Liczba.Re;
     Result.Im:=-Liczba.Im;
end;

function PhaseCplx (Liczba : TComplex) : Extended;
begin
     Result:=ArcTan2(Liczba.Im,Liczba.Re);
end;

function RealToCplx(Real, Imag: Extended): TComplex;
begin
     Result.Re:=Real;
     Result.Im:=Imag;
end;


end.
