unit MPEAnimationsFrame;

interface

// -----------------------------------------------------------------------------
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, 
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, Buttons,
  Math,
  MPEProject, MPEProcessMessage, Menus;

// -----------------------------------------------------------------------------
type
  TAnimationsFrame = class(TFrame)
    GroupBox1: TGroupBox;
    Slice0Panel: TPanel;
    GroupBox2: TGroupBox;
    Slice1Panel: TPanel;
    AnimationTimer: TTimer;
    GroupBox4: TGroupBox;
    AnimationTimelineTrackBar: TTrackBar;
    AnimationStopBtn: TSpeedButton;
    AnimationPlayBtn: TSpeedButton;
    AnimationStartBtn: TSpeedButton;
    AnimationFramesLabel: TLabel;
    GroupBox5: TGroupBox;
    Label1: TLabel;
    AnimationSpeedComboBox: TComboBox;
    Label2: TLabel;
    ReloadBtn: TButton;
    ExportBtn: TButton;
    ExportPopupMenu: TPopupMenu;
    Firstsliceplane1: TMenuItem;
    Secondsliceplane1: TMenuItem;
    ExportFirstSlicePlaneX: TMenuItem;
    ExportFirstSlicePlaneY: TMenuItem;
    ExportFirstSlicePlaneZ: TMenuItem;
    ExportSecondSlicePlaneX: TMenuItem;
    ExportSecondSlicePlaneY: TMenuItem;
    ExportSecondSlicePlaneZ: TMenuItem;
    ExportSaveDialog: TSaveDialog;
    procedure AnimationTimerTimer(Sender: TObject);
    procedure AnimationTimelineTrackBarChange(Sender: TObject);
    procedure AnimationStopBtnClick(Sender: TObject);
    procedure AnimationPlayBtnClick(Sender: TObject);
    procedure AnimationStartBtnClick(Sender: TObject);
    procedure AnimationSpeedComboBoxChange(Sender: TObject);
    procedure ReloadBtnClick(Sender: TObject);
    procedure ExportBtnClick(Sender: TObject);
    procedure ExportSlicePlaneClick(Sender: TObject);
  private

  public
    // Metody
    procedure Paint;

    procedure LoadFromProject;

    // Tworzenie
    constructor Create(AOwner: TComponent); override;

  end;

// -----------------------------------------------------------------------------
var
  AnimationsFrame: TAnimationsFrame;

implementation

// -----------------------------------------------------------------------------
uses
  MPEMain;

{$R *.dfm}

// -----------------------------------------------------------------------------
procedure TAnimationsFrame.Paint;
var
  canvas: TCanvas;
  rect: TRect;
begin

canvas := TCanvas.Create; // TODO: Utworzyc raz, optymalizacje
rect := Bounds(1, 1, Slice0Panel.Width-2, Slice0Panel.Height-2);

// Slice 0
canvas.Handle := GetDC(Slice0Panel.Handle);
Project.Animations.DrawSlice(0, canvas, rect);
ReleaseDC(Slice0Panel.Handle, canvas.Handle);

// Slice 1
canvas.Handle := GetDC(Slice1Panel.Handle);
Project.Animations.DrawSlice(1, canvas, rect);
ReleaseDC(Slice1Panel.Handle, canvas.Handle);

canvas.Free;

end;

// -----------------------------------------------------------------------------
procedure TAnimationsFrame.ReloadBtnClick(Sender: TObject);
begin

ShowProcessMessage(MainForm);

LoadFromProject;

HideProcessMessage;

end;

// -----------------------------------------------------------------------------
procedure TAnimationsFrame.LoadFromProject;
begin

// Odczytywanie klatek animacji
Project.Animations.ImportFromProjectDirectory;

// Skala czasu
AnimationStopBtnClick(Self);
AnimationTimelineTrackBar.Max := Max(0, Project.Animations.Count-1);
AnimationTimelineTrackBar.Position := 0;
AnimationTimelineTrackBarChange(Self);

end;

// -----------------------------------------------------------------------------
constructor TAnimationsFrame.Create(AOwner: TComponent);
begin

inherited Create(AOwner);

AnimationSpeedComboBoxChange(Self);

end;

// -----------------------------------------------------------------------------
procedure TAnimationsFrame.ExportBtnClick(Sender: TObject);
begin
ExportPopupMenu.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y);
end;

// -----------------------------------------------------------------------------
procedure TAnimationsFrame.ExportSlicePlaneClick(Sender: TObject);
begin

if ExportSaveDialog.Execute then
  Project.Animations.ExportToFile(TMenuItem(Sender).GroupIndex, TMenuItem(Sender).Tag, AnimationTimer.Interval, ExportSaveDialog.FileName);

end;

// -----------------------------------------------------------------------------
procedure TAnimationsFrame.AnimationPlayBtnClick(Sender: TObject);
begin
AnimationPlayBtn.Enabled := False;
AnimationStopBtn.Enabled := True;
AnimationTimelineTrackBar.Enabled := False;
AnimationTimer.Enabled := True;
end;

// -----------------------------------------------------------------------------
procedure TAnimationsFrame.AnimationSpeedComboBoxChange(Sender: TObject);
begin
AnimationTimer.Interval := 1000 div StrToInt(AnimationSpeedComboBox.Text);
end;

// -----------------------------------------------------------------------------
procedure TAnimationsFrame.AnimationStartBtnClick(Sender: TObject);
begin
AnimationStopBtnClick(Sender);
AnimationTimelineTrackBar.Position := 0;
end;

// -----------------------------------------------------------------------------
procedure TAnimationsFrame.AnimationStopBtnClick(Sender: TObject);
begin
AnimationTimelineTrackBar.Enabled := True;
AnimationStopBtn.Enabled := False;
AnimationPlayBtn.Enabled := True;
AnimationTimer.Enabled := False;
end;

// -----------------------------------------------------------------------------
procedure TAnimationsFrame.AnimationTimelineTrackBarChange(Sender: TObject);
begin

// Klatka animacji
Project.Animations.Position := AnimationTimelineTrackBar.Position;

// Numer klatki
if AnimationTimelineTrackBar.Max > 0 then
  AnimationFramesLabel.Caption :=
    IntToStr(AnimationTimelineTrackBar.Position+1) + ' / ' +
    IntToStr(AnimationTimelineTrackBar.Max+1)
else
  AnimationFramesLabel.Caption := '0 / 0';

// Rysowanie
Paint;

end;

// -----------------------------------------------------------------------------
procedure TAnimationsFrame.AnimationTimerTimer(Sender: TObject);
begin

// Skala czasu
if AnimationTimelineTrackBar.Position < AnimationTimelineTrackBar.Max then
  AnimationTimelineTrackBar.Position := AnimationTimelineTrackBar.Position+1
else
  AnimationTimelineTrackBar.Position := 0;

end;

end.
