unit MPEBitmap;

interface

// -----------------------------------------------------------------------------
uses
  SysUtils, Classes, Graphics,
  AsphyrePNG, AsphyreTGA;

// -----------------------------------------------------------------------------
type
  TFileFormat = (ffUnknown, ffBMP, ffPNG, ffTGA);

  TMPEBitmap = class(TBitmap)
  private
    // Metody
    procedure ConvertTo32Bit;

  public
    // Metody
    function LoadFromFileEx(const FileName: String): Boolean;
    function LoadFromStreamEx(FileFormat: TFileFormat;
      Stream: TStream): Boolean;

    procedure SetAlphaChannel(A: Byte);

    // Tworzenie
    constructor Create; override;
    
  end;

implementation

// -----------------------------------------------------------------------------
procedure TMPEBitmap.ConvertTo32Bit;
begin

// Konwertowanie do 32 bitow
if PixelFormat = pf24bit then
  begin
  PixelFormat := pf32bit;
  SetAlphaChannel(255);
  end;

end;

// -----------------------------------------------------------------------------
procedure TMPEBitmap.SetAlphaChannel(A: Byte);
var
  x, y: Integer;
  p: PByteArray;
begin

// Ustalanie jednolitej wartosci kanalu przezroczystosci
if PixelFormat = pf32bit then
  for y := 0 to Height-1 do
    begin
    p := ScanLine[y];

    for x := 0 to Width-1 do
      p^[x*4+3] := A;
    
    end;

end;

// -----------------------------------------------------------------------------
function TMPEBitmap.LoadFromFileEx(const FileName: String): Boolean;
var
  ext: String;
  format: TFileFormat;
  stream: TFileStream;
begin
                     
// Format obrazu
ext := LowerCase(ExtractFileExt(FileName));

if ext = '.bmp' then     
  format := ffBMP
else if ext = '.png' then
  format := ffPNG
else if ext = '.tga' then
  format := ffTGA
else
  format := ffUnknown;

// Strumien
stream := TFileStream.Create(FileName, fmOpenRead);

// Inicjalizacja
Result := LoadFromStreamEx(format, stream);

// Zwalnianie
stream.Free;

end;

// -----------------------------------------------------------------------------
function TMPEBitmap.LoadFromStreamEx(FileFormat: TFileFormat;
  Stream: TStream): Boolean;
begin

try
                
  // Dane obrazu
  case FileFormat of
    ffBMP:
      begin
      LoadFromStream(Stream);
      ConvertTo32Bit;
      end;
    ffPNG: LoadPNGtoBMP(Stream, Self);
    ffTGA: LoadTGAtoBMP(Stream, Self);
    ffUnknown:
      begin
      Result := False;
      Exit;
      end;
  end;

  // Inne
  Result := True;

except
  Result := False;
end;

end;

// -----------------------------------------------------------------------------
constructor TMPEBitmap.Create;
begin

inherited Create;

// Parametry
PixelFormat := pf32bit;

end;

end.
