unit MPEFFTGraph;

interface

// -----------------------------------------------------------------------------
uses
  FastFourier,
  MPEExt, MPEGraph, MPEOutputData;

// -----------------------------------------------------------------------------
type
  TMPEFFTDataSeries = class(TMPEDataSeries)
  const
    // Stale
    SAMPLES_FACTOR = 64;
    
  protected
    // Parametry
    FSamples: Cardinal;
    
  public
    // Parametry
    property Samples: Cardinal read FSamples;

    // Metody
    procedure ImportFromOutputData(OutputData: TMPEOutputData); override;

    // Tworzenie
    constructor Create;
    
  end;

implementation

// -----------------------------------------------------------------------------
procedure TMPEFFTDataSeries.ImportFromOutputData(OutputData: TMPEOutputData);
var
  i, point1, point2: Integer;
  x, x1, x2, y1, y2, min, max, step: Double;
begin

if not (OUTPUT_DATA_NONE_COLUMN in [FAxisXColumn, FAxisYColumn]) then
  if OutputData.Count >= 2 then
    with TFastFourier.Create(nil) do
      begin

      // Ilosc probek
      FSamples := NumberOfSamples(OutputData.Count);
      NumSamples := FSamples*SAMPLES_FACTOR;

      // Przeskalowanie danych do ilosci probek, dodanie probek
      min := OutputData.Data[0, FAxisXColumn];
      max := OutputData.Data[OutputData.Count-1, FAxisXColumn];
      step := (max-min) / FSamples;
      point1 := 0;
      point2 := 0;

      for i := 0 to FSamples-1 do
        begin

        x := i*step + min;

        while (point2 <= OutputData.Count-1) and (x >= OutputData.Data[point2, FAxisXColumn]) do
          Inc(point2);

        x1 := OutputData.Data[point1, FAxisXColumn];
        x2 := OutputData.Data[point2, FAxisXColumn];
        y1 := OutputData.Data[point1, FAxisYColumn];
        y2 := OutputData.Data[point2, FAxisYColumn];

        if x1 <> x2 then
          InBuffer[i].Re := (x-x1)*((y2-y1)/(x2-x1))+y1
        else
          InBuffer[i].Re := 0;

        point1 := point2;

        end;

      for i := FSamples to NumSamples-1 do
        InBuffer[i].Re := 0;

      // Szybka transformata Fouriera
      FFT;

      // Dodanie punktow wykresu
      for i := 0 to (NumSamples div 2)-1 do
        AddDataPoint((i / (SAMPLES_FACTOR*max))*1000000000, Power(i));

      // Zwalnianie
      Free;

      end;

end;

// -----------------------------------------------------------------------------
constructor TMPEFFTDataSeries.Create;
begin

inherited Create;

// Parametry
FSamples := 0;

end;

end.
