unit MPEGraphs;

interface

// -----------------------------------------------------------------------------
uses
  Classes,
  MPEExt, MPEGraph, MPEWaveletGraph, MPEOptions;

// -----------------------------------------------------------------------------
type
  TMPEGraphs = class(TObject)
  private
    // Parametry
    FGraphs: TList;

    // Metody parametrow
    function GetGraph(Index: Integer): TMPEGraph;
    function GetCount: Integer;

  public
    // Parametry
    property Graphs[Index: Integer]: TMPEGraph read GetGraph;
    property Count: Integer read GetCount;

    // Metody
    function AddGraph(GraphClass: TClass): TMPEGraph;
    procedure DeleteGraph(Index: Integer);
    procedure DeleteAllGraphs;

    // Tworzenie
    constructor Create;
    destructor Destroy; override;
  
  end;

implementation

// -----------------------------------------------------------------------------
function TMPEGraphs.GetGraph(Index: Integer): TMPEGraph;
begin
Result := TMPEGraph(FGraphs[Index]);
end;

// -----------------------------------------------------------------------------
function TMPEGraphs.GetCount: Integer;
begin
Result := FGraphs.Count;
end;

// -----------------------------------------------------------------------------
function TMPEGraphs.AddGraph(GraphClass: TClass): TMPEGraph;
begin
Result := TMPEGraph(GraphClass.NewInstance).Create;
Result.Width := GRAPH_IMAGE_WIDTH;
Result.Height := GRAPH_IMAGE_HEIGHT;
FGraphs.Add(Result);
end;

// -----------------------------------------------------------------------------
procedure TMPEGraphs.DeleteGraph(Index: Integer);
begin

if (Index >= 0) and (Index <= FGraphs.Count-1) then
  begin
  TMPEGraph(FGraphs[Index]).Free;
  FGraphs.Delete(Index);
  end;

end;

// -----------------------------------------------------------------------------
procedure TMPEGraphs.DeleteAllGraphs;
var
  i: Integer;
begin

if FGraphs.Count > 0 then
  for i := 0 to FGraphs.Count-1 do
    TMPEGraph(FGraphs[i]).Free;

FGraphs.Clear;

end;

// -----------------------------------------------------------------------------
constructor TMPEGraphs.Create;
begin

inherited Create;

// Parametry
FGraphs := TList.Create;

end;

// -----------------------------------------------------------------------------
destructor TMPEGraphs.Destroy;
begin

// Czyszczenie wykresow
DeleteAllGraphs;

// Parametry
FGraphs.Free;

inherited Destroy;

end;

end.
