unit MPEMain;

interface

// -----------------------------------------------------------------------------
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ImgList, ToolWin, XPMan, Menus, ComCtrls,
  XPStyleActnCtrls, ActnList, ActnMan,
  Math,
  MPEAbout, MPEExt, MPEProcessMessage, MPEProject,
  MPEProjectFrame, MPEGraphsFrame, MPEAnimationsFrame;

// -----------------------------------------------------------------------------
type
  TMainForm = class(TForm)
    ActionManager: TActionManager;
    StatusBar: TStatusBar;
    IconsImageList: TImageList;
    CoolBar: TCoolBar;
    ToolBar: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    NewProjectAction: TAction;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    OpenProjectAction: TAction;
    SaveProjectAction: TAction;
    OptionsAction: TAction;
    ProjectAction: TAction;
    GraphsAction: TAction;
    AnimationsAction: TAction;
    SaveProjectSaveDialog: TSaveDialog;
    OpenProjectOpenDialog: TOpenDialog;
    AboutAction: TAction;
    ExitAction: TAction;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    ToolButton12: TToolButton;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure NewProjectActionExecute(Sender: TObject);
    procedure ProjectActionExecute(Sender: TObject);
    procedure GraphsActionExecute(Sender: TObject);
    procedure SaveProjectActionExecute(Sender: TObject);
    procedure OpenProjectActionExecute(Sender: TObject);
    procedure OptionsActionExecute(Sender: TObject);
    procedure AnimationsActionExecute(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure ExitActionExecute(Sender: TObject);
    procedure AboutActionExecute(Sender: TObject);
  private
    // Zmienne
    Frames: TList;

    // Metody
    procedure SwitchFrame(Frame: TFrame; Action: TAction);

  public

  end;

// -----------------------------------------------------------------------------
var
  MainForm: TMainForm;
  MainDir: String;

implementation

uses
  MPEOptions;

{$R *.dfm}

// -----------------------------------------------------------------------------
procedure TMainForm.SwitchFrame(Frame: TFrame; Action: TAction);
begin

// Przenoszenie ramki
Frame.BringToFront;

// Deaktywacja przyciskow
ProjectAction.Checked := False;
GraphsAction.Checked := False;
AnimationsAction.Checked := False;

// Przycisk aktywnej ramki
Action.Checked := True;

end;

// -----------------------------------------------------------------------------
procedure TMainForm.NewProjectActionExecute(Sender: TObject);
begin

if (not Assigned(Project)) or   // TODO: Wyizolowac i dodac do exit program
   (Project.Saved) or
   (MessageBox(Handle, 'Changes in curret project has not been saved. Do you wish to continue?', PChar(MainForm.Caption), MB_ICONQUESTION or MB_YESNO) = IDYES) then
  begin

  // Zwalnianie, tworzenie projektu
  if Assigned(Project) then
    begin
    Project.Free;
    Project := nil;
    end;

  // Tworzenie nowego projektu
  Project := TMPEProject.Create;

  // Ladowanie danych projektu
  ProjectFrame.LoadFromProject;
  GraphsFrame.LoadFromProject;
  AnimationsFrame.LoadFromProject;
  Project.Loaded;

  // Informacje o projekcie
  ProjectActionExecute(Sender);

  end;

end;

// -----------------------------------------------------------------------------
procedure TMainForm.OpenProjectActionExecute(Sender: TObject);
begin

if OpenProjectOpenDialog.Execute then
  begin

  // Zwalnianie projektu
  if Assigned(Project) then
    begin
    Project.Free;
    Project := nil;
    end;

  // Tworzenie nowego projektu
  Project := TMPEProject.Create;

  // Odczytywanie projektu
  if Project.LoadFromFile(OpenProjectOpenDialog.FileName) then
    begin

    ShowProcessMessage(MainForm);

    // Odczytywanie danych projektu
    ProjectFrame.LoadFromProject;
    GraphsFrame.LoadFromProject;
    AnimationsFrame.LoadFromProject;
    Project.Loaded;

    // Informacje o projekcie
    ProjectActionExecute(Sender);

    HideProcessMessage;
    
    end
  else
    MessageBox(Handle, 'Incorrect file version!', PChar(MainForm.Caption), MB_ICONERROR);
              
  end;

end;

// -----------------------------------------------------------------------------
procedure TMainForm.OptionsActionExecute(Sender: TObject);
begin

OptionsForm.LoadFromRegistry;

if OptionsForm.ShowModal = mrOK then
  OptionsForm.SaveToRegistry
else
  OptionsForm.LoadFromRegistry;
             
end;

// -----------------------------------------------------------------------------
procedure TMainForm.ProjectActionExecute(Sender: TObject);
begin
SwitchFrame(ProjectFrame, ProjectAction);
end;

// -----------------------------------------------------------------------------
procedure TMainForm.SaveProjectActionExecute(Sender: TObject);
begin

if SaveProjectSaveDialog.Execute then
  begin

  ShowProcessMessage(MainForm);

  // Zapisywanie danych projektu
  ProjectFrame.SaveToProject;
  GraphsFrame.SaveToProject;
  Project.Loaded;

  // Zapisanie projektu
  Project.SaveToFile(SaveProjectSaveDialog.FileName);

  HideProcessMessage;

  end;

end;

// -----------------------------------------------------------------------------
procedure TMainForm.AboutActionExecute(Sender: TObject);
begin
AboutForm := TAboutForm.Create(Self);
AboutForm.ShowModal;
AboutForm.Free;
AboutForm := nil;
end;

// -----------------------------------------------------------------------------
procedure TMainForm.AnimationsActionExecute(Sender: TObject);
begin
SwitchFrame(AnimationsFrame, AnimationsAction);
AnimationsFrame.Paint;
end;

// -----------------------------------------------------------------------------
procedure TMainForm.ExitActionExecute(Sender: TObject);
begin
Close;
end;

// -----------------------------------------------------------------------------
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
var
  b: Byte;
begin

// Opcje
OptionsForm.Free;
OptionsForm := nil;

// Ramki
for b := 0 to Frames.Count-1 do
  TFrame(Frames[b]).Free;

// Projekt
if Assigned(Project) then
  Project.Free;

end;

// -----------------------------------------------------------------------------
procedure TMainForm.FormCreate(Sender: TObject);
var
  b: Byte;
begin

// Folder aplikacji
MainDir := ExtractFileDir(Application.ExeName);
if MainDir[Length(MainDir)] <> '\' then
  MainDir := MainDir + '\';

// Inne
Randomize;

// Interface
StatusBar.Panels.Items[1].Text := VERSION_NAME;

IconsImageList.Clear;
ConvertTo32BitImageList(IconsImageList);
for b := 0 to Length(ICONS_LIST)-1 do
  AddIconTo32BitImageList(IconsImageList, MainDir + ICONS_DIR + ICONS_LIST[b]);

OpenProjectOpenDialog.InitialDir := MainDir;

// Opcje
OptionsForm := TOptionsForm.Create(Self);
OptionsForm.LoadFromRegistry;

// Ramki
ProjectFrame := TProjectFrame.Create(Self);
GraphsFrame := TGraphsFrame.Create(Self);
AnimationsFrame := TAnimationsFrame.Create(Self);

Frames := TList.Create;
Frames.Add(ProjectFrame);
Frames.Add(GraphsFrame);
Frames.Add(AnimationsFrame);

for b := Frames.Count-1 downto 0 do
  begin
  TFrame(Frames[b]).Parent := Self;
  TFrame(Frames[b]).Left := 8;
  TFrame(Frames[b]).Top := CoolBar.Height + 8;
  end;

// Projekt
NewProjectActionExecute(Sender);

end;

// -----------------------------------------------------------------------------
procedure TMainForm.FormPaint(Sender: TObject);
begin

if AnimationsAction.Checked then
  AnimationsFrame.Paint;

end;

// -----------------------------------------------------------------------------
procedure TMainForm.GraphsActionExecute(Sender: TObject);
begin
SwitchFrame(GraphsFrame, GraphsAction);
end;

end.
