unit MPEMaterialProperties;

interface

// -----------------------------------------------------------------------------
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls,
  MPEExt;

// -----------------------------------------------------------------------------
type
  TMaterialPropertiesForm = class(TForm)
    StatusBar: TStatusBar;
    CancelBtn: TButton;
    SaveBtn: TButton;
    PageControl: TPageControl;
    TabSheet1: TTabSheet;
    GroupBox1: TGroupBox;
    MaterialInputDataListView: TListView;
    GroupBox2: TGroupBox;
    MaterialPropertiesDeleteBtn: TButton;
    Label6: TLabel;
    thetaCmp: TEdit;
    phiCmp: TEdit;
    Label1: TLabel;
    K1Cmp: TEdit;
    Label2: TLabel;
    K2Cmp: TEdit;
    Label3: TLabel;
    JsCmp: TEdit;
    Label4: TLabel;
    ACmp: TEdit;
    Label5: TLabel;
    alphaCmp: TEdit;
    Label7: TLabel;
    Label8: TLabel;
    MaterialPropertiesAddBtn: TButton;
    psiCmp: TComboBox;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label16: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure MaterialPropertiesDeleteBtnClick(Sender: TObject);
    procedure MaterialPropertiesAddBtnClick(Sender: TObject);
  private
  public
    // Metody
    procedure LoadFromFile(const FileName: String);
    procedure SaveToFile(const FileName: String);

  end;

// -----------------------------------------------------------------------------
var
  MaterialPropertiesForm: TMaterialPropertiesForm;

implementation

{$R *.dfm}

// -----------------------------------------------------------------------------
procedure TMaterialPropertiesForm.LoadFromFile(const FileName: String);
var
  b: Byte;
  i: Integer;
  line: String;
  krnfile: TStringList;
  params: array[0..MATERIAL_INPUT_DATA_COLUMNS_COUNT-1] of String;
  item: TListItem;
begin

// Odczytywanie pliku
krnfile := TStringList.Create;
krnfile.LoadFromFile(FileName);

// Parsowanie danych
if krnfile.Count > 0 then
  for i := 0 to krnfile.Count-1 do
    begin

    // Odczytywanie linii
    line := krnfile.Strings[i];

    if Length(line) > 0 then
      if line[1] <> MATERIAL_INPUT_DATA_COMMENT_CHAR then
        begin

        // Oczyszczanie lini
        StripLine(line, MATERIAL_INPUT_DATA_COMMENT_CHAR);

        // Rozdzielanie wartosci
        Split(' ', line, params);

        // Dodawanie do listy
        item := MaterialInputDataListView.Items.Add;
        item.Caption := StrToStrEx(params[0], MATERIAL_INPUT_DECIMAL_SEPARATOR);

        for b := 1 to MATERIAL_INPUT_DATA_COLUMNS_COUNT-1 do
          item.SubItems.Add(StrToStrEx(params[b], MATERIAL_INPUT_DECIMAL_SEPARATOR));

        end;

    end;

// Zwalnianie listy danych pliku
krnfile.Free;

end;

// -----------------------------------------------------------------------------
procedure TMaterialPropertiesForm.SaveToFile(const FileName: String);
var
  b: Byte;
  i: Integer;
  line: String;
  dir, backup_filename: String;
  krnfile: TStringList;
begin

// Kopia pliku
if FileExists(FileName) then
  begin

  // Folder pliku
  dir := ExtractFileDir(FileName);
  if dir[Length(dir)] <> '\' then
    dir := dir + '\';

  // Plik kopii
  backup_filename := dir + '\' + MATERIAL_INPUT_DATA_BACKUP_FILENAME_PREFIX + ExtractFileName(FileName);

  // Tworzenie kopii
  if not FileExists(backup_filename) then
    RenameFile(FileName, backup_filename);

  end;

// Tworzenie pliku
krnfile := TStringList.Create;

// Parsowanie parametrow
if MaterialInputDataListView.Items.Count > 0 then
  for i := 0 to MaterialInputDataListView.Items.Count-1 do
    begin

    line := StrToStrEx2(MaterialInputDataListView.Items[i].Caption, MATERIAL_INPUT_DECIMAL_SEPARATOR);

    for b := 1 to MATERIAL_INPUT_DATA_COLUMNS_COUNT-1 do
      line := line + ' ' + StrToStrEx2(MaterialInputDataListView.Items[i].SubItems.Strings[b-1], MATERIAL_INPUT_DECIMAL_SEPARATOR);

    krnfile.Add(line);

    end;

// Zapisywanie do pliku
krnfile.SaveToFile(FileName);

// Zwalnianie listy danych pliku
krnfile.Free;

end;

// -----------------------------------------------------------------------------
procedure TMaterialPropertiesForm.MaterialPropertiesAddBtnClick(
  Sender: TObject);
var
  item: TListItem;
begin

// Dodawanie wlasnosci materialu
item := MaterialInputDataListView.Items.Add;
item.Caption := thetaCmp.Text;
item.SubItems.Add(phiCmp.Text);
item.SubItems.Add(K1Cmp.Text);
item.SubItems.Add(K2Cmp.Text);
item.SubItems.Add(JsCmp.Text);
item.SubItems.Add(ACmp.Text);
item.SubItems.Add(alphaCmp.Text);
item.SubItems.Add(psiCmp.Text);

// Czyszczenia zawartosci komponentow
thetaCmp.Text := '';
phiCmp.Text := '';
K1Cmp.Text := '';
K2Cmp.Text := '';
JsCmp.Text := '';
ACmp.Text := '';
alphaCmp.Text := '';
psiCmp.Text := '';

end;

// -----------------------------------------------------------------------------
procedure TMaterialPropertiesForm.MaterialPropertiesDeleteBtnClick(
  Sender: TObject);
var
  index: Integer;
begin

index := MaterialInputDataListView.ItemIndex;

if index <> -1 then
  begin
  MaterialInputDataListView.Items.Delete(index);
  MaterialInputDataListView.ItemIndex := -1;
  end;

end;

// -----------------------------------------------------------------------------
procedure TMaterialPropertiesForm.FormCreate(Sender: TObject);
var
  b: Byte;
  column: TListColumn;
begin

// Kolumny pliku z wlasciwosciami materialu
MaterialInputDataListView.Columns.BeginUpdate;

for b := 0 to MATERIAL_INPUT_DATA_COLUMNS_COUNT-1 do
  if MATERIAL_INPUT_DATA_COLUMNS[b].Name <> '' then
    begin
    column := MaterialInputDataListView.Columns.Add;
    column.Caption := GetColumnFullName(MATERIAL_INPUT_DATA_COLUMNS, b);
    column.Width := 75;
    end;

MaterialInputDataListView.Columns.EndUpdate;

end;

end.
