unit MPEOutputDataPreview;

interface

// -----------------------------------------------------------------------------
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls,
  MPEExt, MPEProject;

// -----------------------------------------------------------------------------
type
  TOutputDataPreviewForm = class(TForm)
    OutputDataListView: TListView;
    CloseBtn: TButton;
    StatusBar: TStatusBar;
    procedure FormCreate(Sender: TObject);
  private
  public
    // Metody
    procedure LoadFromProject;

  end;

// -----------------------------------------------------------------------------
var
  OutputDataPreviewForm: TOutputDataPreviewForm;

implementation

{$R *.dfm}

// -----------------------------------------------------------------------------
procedure TOutputDataPreviewForm.LoadFromProject;
var
  i: Integer;
  b: Byte;
  item: TListItem;
begin

OutputDataListView.Items.BeginUpdate;
OutputDataListView.Items.Clear;

if Project.OutputData.Count > 0 then
  for i := 0 to Project.OutputData.Count-1 do
    begin
    
    item := OutputDataListView.Items.Add;

    item.Caption := FloatToStrF(Project.OutputData.Data[i, 0], ffGeneral, 3, 2);

    for b := 1 to OUTPUT_DATA_COLUMNS_COUNT-1 do
      if OUTPUT_DATA_COLUMNS[b].Name <> '' then
        item.SubItems.Add(FloatToStrF(Project.OutputData.Data[i, b], ffGeneral, 3, 2));

    end;

OutputDataListView.Items.EndUpdate;

end;

// -----------------------------------------------------------------------------
procedure TOutputDataPreviewForm.FormCreate(Sender: TObject);
var
  b: Byte;
  column: TListColumn;
begin

// Kolumny pliku wyjsciowego
OutputDataListView.Columns.BeginUpdate;

for b := 0 to OUTPUT_DATA_COLUMNS_COUNT-1 do
  if OUTPUT_DATA_COLUMNS[b].Name <> '' then
    begin
    column := OutputDataListView.Columns.Add;
    column.Caption := GetColumnFullName(OUTPUT_DATA_COLUMNS, b);
    column.Width := 75;
    end;

OutputDataListView.Columns.EndUpdate;

end;

end.
