unit MPEProcessMessage;

interface

// -----------------------------------------------------------------------------
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls;

// -----------------------------------------------------------------------------
type
  TProcessMessageForm = class(TForm)
    ProcessMessagePanel: TPanel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
  private
  public
  end;

// -----------------------------------------------------------------------------
var
  ProcessMessageForm: TProcessMessageForm;

// -----------------------------------------------------------------------------
procedure ShowProcessMessage(Form: TForm; const ProcessMessage: String = 'Please wait...');
procedure HideProcessMessage;

implementation

{$R *.dfm}

// -----------------------------------------------------------------------------
procedure ShowProcessMessage(Form: TForm; const ProcessMessage: String = 'Please wait...');
begin

if not Assigned(ProcessMessageForm) then
  begin

  Form.Enabled := False;

  ProcessMessageForm := TProcessMessageForm.Create(Form);
  ProcessMessageForm.ProcessMessagePanel.Caption := ProcessMessage;
  ProcessMessageForm.Show;

  Application.ProcessMessages;

  end
else
  ProcessMessageForm.Tag := ProcessMessageForm.Tag + 1;

end;

// -----------------------------------------------------------------------------
procedure HideProcessMessage;
begin

if Assigned(ProcessMessageForm) then
  if ProcessMessageForm.Tag = 0 then
    begin

    ProcessMessageForm.Close;

    TForm(ProcessMessageForm.Owner).Enabled := True;

    ProcessMessageForm.Free;
    ProcessMessageForm := nil;

    end
  else
    ProcessMessageForm.Tag := ProcessMessageForm.Tag - 1;

end;

// -----------------------------------------------------------------------------
procedure TProcessMessageForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
Action := caNone;
end;

// -----------------------------------------------------------------------------
procedure TProcessMessageForm.FormCreate(Sender: TObject);
begin
ProcessMessagePanel.Align := alClient;
end;

end.
