unit MPESimulationEdit;

interface

// -----------------------------------------------------------------------------
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls,
  MPEExt, ExtCtrls;

// -----------------------------------------------------------------------------
type
  TEditParam = record
    Numeric: Boolean;
    SubParams: Byte;
  end;

  TComboBoxParam = record
    Values: array of String;
  end;

// -----------------------------------------------------------------------------
type
  TSimulationEditForm = class(TForm)
    StatusBar: TStatusBar;
    PageControl: TPageControl;
    TabSheet1: TTabSheet;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    simNameCmp: TEdit;
    CancelBtn: TButton;
    SaveBtn: TButton;
    TabSheet5: TTabSheet;
    GroupBox2: TGroupBox;
    Label2: TLabel;
    meshtypeCmp: TComboBox;
    GroupBox4: TGroupBox;
    Label6: TLabel;
    refineCmp: TEdit;
    GroupBox5: TGroupBox;
    Label7: TLabel;
    Label8: TLabel;
    meshdistCmp: TComboBox;
    distparCmp: TEdit;
    mesh_scaleCmp2: TEdit;
    mesh_scaleCmp1: TEdit;
    mesh_scaleCmp: TEdit;
    shiftCmp: TEdit;
    shiftCmp1: TEdit;
    shiftCmp2: TEdit;
    Label44: TLabel;
    Label45: TLabel;
    GroupBox24: TGroupBox;
    Label46: TLabel;
    optimizebwCmp: TComboBox;
    metispartitionCmp: TComboBox;
    Label47: TLabel;
    TabSheet6: TTabSheet;
    Label35: TLabel;
    sizeCmp: TEdit;
    GroupBox3: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    init_magparmCmp: TEdit;
    inpCmp: TEdit;
    init_magCmp: TComboBox;
    init_magCmp1: TCheckBox;
    GroupBox6: TGroupBox;
    Label9: TLabel;
    nslicepropserCmp: TEdit;
    nslicepropparCmp: TEdit;
    Label48: TLabel;
    TabSheet7: TTabSheet;
    GroupBox11: TGroupBox;
    Label20: TLabel;
    modeCmp: TComboBox;
    TabSheet8: TTabSheet;
    TabSheet3: TTabSheet;
    GroupBox13: TGroupBox;
    Label28: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    condinp_equilCmp: TComboBox;
    condinp_jCmp: TEdit;
    condinp_tCmp: TEdit;
    ts_logstepsCmp: TEdit;
    ts_nstepsCmp: TEdit;
    Label56: TLabel;
    Label57: TLabel;
    GroupBox7: TGroupBox;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    slice_nCmp: TEdit;
    slice_nCmp1: TEdit;
    slice_nCmp2: TEdit;
    slice_pCmp2: TEdit;
    slice_pCmp1: TEdit;
    slice_pCmp: TEdit;
    slice_gCmp: TEdit;
    resCmp: TEdit;
    GroupBox8: TGroupBox;
    Label14: TLabel;
    Label15: TLabel;
    line_vCmp: TEdit;
    line_pCmp: TEdit;
    line_pCmp1: TEdit;
    line_vCmp1: TEdit;
    line_vCmp2: TEdit;
    line_pCmp2: TEdit;
    GroupBox25: TGroupBox;
    Label58: TLabel;
    logpidCmp: TComboBox;
    TabSheet4: TTabSheet;
    GroupBox15: TGroupBox;
    Label32: TLabel;
    Label33: TLabel;
    tolCmp: TEdit;
    renormtolCmp: TEdit;
    GroupBox18: TGroupBox;
    Label36: TLabel;
    jfinalCmp: TEdit;
    TabSheet9: TTabSheet;
    GroupBox21: TGroupBox;
    ksp_monitorCmp: TCheckBox;
    GroupBox23: TGroupBox;
    Label42: TLabel;
    Label43: TLabel;
    pc_typeCmp: TComboBox;
    pc_icc_shiftCmp: TCheckBox;
    sub_pc_typeCmp: TComboBox;
    sub_pc_icc_shiftCmp: TCheckBox;
    ksp_max_itCmp: TEdit;
    ksp_rtolCmp: TEdit;
    ksp_atolCmp: TEdit;
    ksp_divtolCmp: TEdit;
    Label40: TLabel;
    Label41: TLabel;
    Label39: TLabel;
    Label38: TLabel;
    TabSheet2: TTabSheet;
    TabSheet10: TTabSheet;
    condinp_equil_jCmp: TEdit;
    Label17: TLabel;
    Label18: TLabel;
    Label31: TLabel;
    slice2_nCmp: TEdit;
    slice2_nCmp1: TEdit;
    slice2_nCmp2: TEdit;
    slice2_pCmp2: TEdit;
    slice2_pCmp1: TEdit;
    slice2_pCmp: TEdit;
    slice2_gCmp: TEdit;
    Label91: TLabel;
    Label95: TLabel;
    mfinalCmp: TEdit;
    mfinalCmp1: TEdit;
    mfinalCmp2: TEdit;
    condinp_file_t_nsCmp: TEdit;
    Label99: TLabel;
    MagneticFieldsPanel: TPanel;
    MagneticFieldsScrollPanel: TPanel;
    GroupBox10: TGroupBox;
    Label19: TLabel;
    Label37: TLabel;
    Label49: TLabel;
    Label50: TLabel;
    Label51: TLabel;
    Label52: TLabel;
    Label53: TLabel;
    demagCmp: TComboBox;
    hdemag_u1_ksp_typeCmp: TComboBox;
    hdemag_u1_ksp_rtolCmp: TEdit;
    hdemag_u1_ksp_atolCmp: TEdit;
    hdemag_u2_ksp_typeCmp: TComboBox;
    hdemag_u2_ksp_rtolCmp: TEdit;
    hdemag_u2_ksp_atolCmp: TEdit;
    GroupBox12: TGroupBox;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    Label21: TLabel;
    Label16: TLabel;
    hextiniCmp: TEdit;
    hthetaCmp: TEdit;
    hphiCmp: TEdit;
    hstepCmp: TEdit;
    hsweepCmp: TEdit;
    hfinalCmp: TEdit;
    hext_ho_htfileCmp: TEdit;
    hext_ho_hstepfileCmp: TEdit;
    GroupBox17: TGroupBox;
    Label54: TLabel;
    helastic_propfileCmp: TEdit;
    GroupBox20: TGroupBox;
    Label55: TLabel;
    hext_cuCmp: TComboBox;
    MagneticFieldsScrollBar: TScrollBar;
    GroupBox9: TGroupBox;
    Label100: TLabel;
    Label101: TLabel;
    Label102: TLabel;
    Label103: TLabel;
    Label104: TLabel;
    hext_kqCmp: TEdit;
    hext_kq_gapiniCmp: TEdit;
    hext_kq_gapsizeCmp: TEdit;
    hext_kq_x_offsetCmp: TEdit;
    hext_kq_z_offsetCmp: TEdit;
    GroupBox14: TGroupBox;
    Label105: TLabel;
    hext_pyCmp: TEdit;
    TAOEnergyMinimizationPanel: TPanel;
    TAOEnergyMinimizationScrollBar: TScrollBar;
    TAOEnergyMinimizationScrollPanel: TPanel;
    GroupBox16: TGroupBox;
    Label34: TLabel;
    magdistCmp: TEdit;
    GroupBox22: TGroupBox;
    Label59: TLabel;
    Label60: TLabel;
    Label61: TLabel;
    Label62: TLabel;
    Label63: TLabel;
    Label64: TLabel;
    Label65: TLabel;
    Label66: TLabel;
    Label67: TLabel;
    Label68: TLabel;
    Label69: TLabel;
    Label70: TLabel;
    Label71: TLabel;
    Label72: TLabel;
    Label73: TLabel;
    Label74: TLabel;
    Label75: TLabel;
    Label76: TLabel;
    Label97: TLabel;
    Label98: TLabel;
    tao_methodCmp: TComboBox;
    tao_ls_maxfevCmp: TEdit;
    tao_ls_ftolCmp: TEdit;
    tao_ls_gtolCmp: TEdit;
    tao_ls_rtolCmp: TEdit;
    tao_ls_stepminCmp: TEdit;
    tao_ls_stepmaxCmp: TEdit;
    tao_viewCmp: TCheckBox;
    tao_fatolCmp: TEdit;
    tao_frtolCmp: TEdit;
    tao_catolCmp: TEdit;
    tao_crtolCmp: TEdit;
    tao_gatolCmp: TEdit;
    tao_grtolCmp: TEdit;
    tao_gttolCmp: TEdit;
    tao_max_itsCmp: TEdit;
    tao_max_funcsCmp: TEdit;
    tao_fminCmp: TEdit;
    tao_steptolCmp: TEdit;
    tao_trust0Cmp: TEdit;
    tao_view_hessianCmp: TCheckBox;
    tao_view_gradientCmp: TCheckBox;
    tao_view_jacobianCmp: TCheckBox;
    tao_view_constraintsCmp: TCheckBox;
    tao_cancelmonitorsCmp: TCheckBox;
    tao_monitorCmp: TCheckBox;
    tao_smonitorCmp: TCheckBox;
    tao_vecmonitorCmp: TCheckBox;
    tao_vecmonitor_updateCmp: TCheckBox;
    tao_xmonitorCmp: TCheckBox;
    tao_lmm_vectorsCmp: TEdit;
    tao_kspviewCmp: TCheckBox;
    tao_unitstepCmp: TCheckBox;
    tao_lmvmhCmp: TCheckBox;
    LGGTimeIntegrationPanel: TPanel;
    LGGTimeIntegrationScrollPanel: TPanel;
    GroupBox26: TGroupBox;
    Label79: TLabel;
    Label80: TLabel;
    Label81: TLabel;
    Label82: TLabel;
    Label83: TLabel;
    Label84: TLabel;
    Label85: TLabel;
    ts_init_timeCmp: TEdit;
    ts_max_timeCmp: TEdit;
    ts_dtCmp: TEdit;
    ts_pvode_atolCmp: TEdit;
    ts_pvode_rtolCmp: TEdit;
    ts_pvode_linear_toleranceCmp: TEdit;
    ts_pvode_typeCmp: TComboBox;
    GroupBox27: TGroupBox;
    Label86: TLabel;
    Label87: TLabel;
    Label88: TLabel;
    Label89: TLabel;
    Label90: TLabel;
    maxlCmp: TEdit;
    mintimestepCmp: TEdit;
    maxtimestepCmp: TEdit;
    maxorderCmp: TEdit;
    preconCmp: TComboBox;
    GroupBox28: TGroupBox;
    Label92: TLabel;
    Label93: TLabel;
    Label94: TLabel;
    Label96: TLabel;
    psolve_ksp_typeCmp: TComboBox;
    psolve_ksp_atolCmp: TEdit;
    psolve_ksp_rtolCmp: TEdit;
    psolve_ksp_divtolCmp: TEdit;
    GroupBox19: TGroupBox;
    Label77: TLabel;
    Label78: TLabel;
    magdist_llgCmp: TEdit;
    magdist_nsCmp: TEdit;
    LGGTimeIntegrationScrollBar: TScrollBar;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TAOEnergyMinimizationScrollBarChange(Sender: TObject);
    procedure MagneticFieldsScrollBarChange(Sender: TObject);
    procedure LGGTimeIntegrationScrollBarChange(Sender: TObject);
  private
    // Zmienne
    EditParamTypes: array of TEditParam;
    ComboBoxParamTypes: array of TComboBoxParam;

    // Metody
    function GetIndexFromValue(ParamType: Byte;
      Value: String): Integer;
    function GetValueFromIndex(ParamType: Byte;
      Index: Integer): String;

  public
    // Metody
    procedure LoadFromFile(const FileName: String;
      DefaultValues: Boolean); overload;
    procedure LoadFromFile(const FileName: String); overload;
    procedure SaveToFile(const FileName: String);

  end;

// -----------------------------------------------------------------------------
var
  SimulationEditForm: TSimulationEditForm;

implementation

uses
  MPEMain;

{$R *.dfm}

// -----------------------------------------------------------------------------
function TSimulationEditForm.GetIndexFromValue(ParamType: Byte;
  Value: String): Integer;
var
  i: Integer;
begin

Result := 0;

if Length(ComboBoxParamTypes[ParamType].Values) > 0 then
  for i := 0 to Length(ComboBoxParamTypes[ParamType].Values)-1 do
    if ComboBoxParamTypes[ParamType].Values[i] = Value then
      begin
      Result := i+1;
      Break;
      end;

end;

// -----------------------------------------------------------------------------
function TSimulationEditForm.GetValueFromIndex(ParamType: Byte;
  Index: Integer): String;
begin

if (Index >= 1) and (Index <= Length(ComboBoxParamTypes[ParamType].Values)) then
  Result := ComboBoxParamTypes[ParamType].Values[Index-1]
else
  Result := '';

end;

// -----------------------------------------------------------------------------
procedure TSimulationEditForm.LoadFromFile(const FileName: String;
  DefaultValues: Boolean);
var
  b: Byte;
  i, option: Integer;
  line: String;
  param, value, text: String;
  multiple_value: array of String;
  allopt: TStringList;
  component: TComponent;
  edit, multiple_edit: TEdit;
  combobox: TComboBox;
  checkbox: TCheckBox;
begin

// Odczytywanie pliku
allopt := TStringList.Create;
allopt.LoadFromFile(FileName);

// Parsowanie danych
if allopt.Count > 0 then
  for i := 0 to allopt.Count-1 do
    begin

    // Odczytywanie linii
    line := allopt.Strings[i];

    if Length(line) > 0 then
      if line[1] = INPUT_DATA_PARAM_CHAR then
        begin

        // Oczyszczanie lini
        StripLine(line, INPUT_DATA_COMMENT_CHAR);

        // Parametr, wartosc
        SplitParamValue(line, param, value);

        // Komponent
        component := FindComponent(param + INPUT_DATA_COMPONENT_NAME_SURFIX);

        // Typ pola, odczyt wartosci
        if Assigned(component) then
          if component is TEdit then
            begin

            // Pole tekstowe
            edit := TEdit(component);

            // Wartosci kilkuskladnikowe
            SetLength(multiple_value, EditParamTypes[edit.Tag].SubParams+1);
            Split(INPUT_DATA_MULTIPLE_VALUES_SEPARATOR, value, multiple_value);

            // Wartosc pola
            for b := 0 to Length(multiple_value)-1 do
              begin

              // Pole skadowe dla parametrow kilkuskladnikowych
              if b = 0 then
                multiple_edit := edit
              else
                multiple_edit := TEdit(FindComponent(param + INPUT_DATA_COMPONENT_NAME_SURFIX + IntToStr(b)));

              // Typ danych (numeryczny badz tekstowy)
              if EditParamTypes[edit.Tag].Numeric then
                text := StrToStrEx(multiple_value[b], INPUT_DATA_DECIMAL_SEPARATOR)
              else
                text := multiple_value[b];

              // Wartosc domyslna, wartosc parametru
              if DefaultValues then
                begin
                multiple_edit.Hint := DEFAULT_INPUT_DATA_COMPONENT_HINT_PREFIX + text;
                multiple_edit.ShowHint := True;
                end
              else
                multiple_edit.Text := text;

              end;

            end
          else if component is TComboBox then
            begin

            // Pole listy
            combobox := TComboBox(component);

            // Pozycja listy, pola specjalne
            if param = 'init_mag' then
              begin

              // Pole wyboru dla pola listy
              checkbox := TCheckBox(FindComponent(param + INPUT_DATA_COMPONENT_NAME_SURFIX + '1'));

              // Dane
              if (Length(value) >= 2) and (value[1] = '-') then
                begin
                option := GetIndexFromValue(combobox.Tag, Copy(value, 2, Length(value)-1));
                checkbox.Checked := True;
                end
              else
                begin
                option := GetIndexFromValue(combobox.Tag, value);
                checkbox.Checked := False;
                end;

              end
            else
              option := GetIndexFromValue(combobox.Tag, value);

            // Wartosc domyslna, wartosc parametru
            if DefaultValues then
              begin
              combobox.Hint := DEFAULT_INPUT_DATA_COMPONENT_HINT_PREFIX + combobox.Items[option];
              combobox.ShowHint := True;
              end
            else
              combobox.ItemIndex := option;

            end
          else if component is TCheckBox then
            begin

            // Pole wyboru
            checkbox := TCheckBox(component);

            // Zaznaczenie pola wyboru
            checkbox.Checked := True;

            end;

        end;

    end;

// Zwalnianie listy danych pliku
allopt.Free;

end;

// -----------------------------------------------------------------------------
procedure TSimulationEditForm.LGGTimeIntegrationScrollBarChange(
  Sender: TObject);
begin
if LGGTimeIntegrationScrollBar.Position <= LGGTimeIntegrationScrollBar.Max-LGGTimeIntegrationScrollBar.PageSize then
  LGGTimeIntegrationScrollPanel.Top := -LGGTimeIntegrationScrollBar.Position
else
  LGGTimeIntegrationScrollPanel.Top := -(LGGTimeIntegrationScrollBar.Max-LGGTimeIntegrationScrollBar.PageSize);
end;

// -----------------------------------------------------------------------------
procedure TSimulationEditForm.LoadFromFile(const FileName: String);
begin
LoadFromFile(MainDir + OTHERS_DIR + DEFAULT_INPUT_DATA_FILENAME, True);
LoadFromFile(FileName, False);
end;

// -----------------------------------------------------------------------------
procedure TSimulationEditForm.MagneticFieldsScrollBarChange(Sender: TObject);
begin
if MagneticFieldsScrollBar.Position <= MagneticFieldsScrollBar.Max-MagneticFieldsScrollBar.PageSize then
  MagneticFieldsScrollPanel.Top := -MagneticFieldsScrollBar.Position
else
  MagneticFieldsScrollPanel.Top := -(MagneticFieldsScrollBar.Max-MagneticFieldsScrollBar.PageSize);
end;

// -----------------------------------------------------------------------------
procedure TSimulationEditForm.SaveToFile(const FileName: String);
var
  b: Byte;
  i: Integer;
  dir, backup_filename: String;
  param, value: String;
  allopt: TStringList;
  component: TComponent;
  edit, multiple_edit: TEdit;
  combobox: TComboBox;
  checkbox: TCheckBox;
begin

// Kopia pliku
if FileExists(FileName) then
  begin

  // Folder pliku
  dir := ExtractFileDir(FileName);
  if dir[Length(dir)] <> '\' then
    dir := dir + '\';

  // Plik kopii
  backup_filename := dir + '\' + INPUT_DATA_BACKUP_FILENAME_PREFIX + ExtractFileName(FileName);

  // Tworzenie kopii
  if not FileExists(backup_filename) then
    RenameFile(FileName, backup_filename);

  end;

// Tworzenie pliku
allopt := TStringList.Create;

// Parsowanie parametrow
for i := 0 to ComponentCount-1 do
  if Pos(INPUT_DATA_COMPONENT_NAME_SURFIX, Components[i].Name) = Length(Components[i].Name) - Length(INPUT_DATA_COMPONENT_NAME_SURFIX) + 1 then
    begin

    // Komponent
    component := Components[i];

    // Parametr, wartosc
    param := Copy(component.Name, 1, Pos(INPUT_DATA_COMPONENT_NAME_SURFIX, component.Name)-1);
    value := '';

    // Typ pola, odczyt wartosci
    if component is TEdit then
      begin

      // Pole tekstowe
      edit := TEdit(component);

      // Wartosc pola
      for b := 0 to (EditParamTypes[edit.Tag].SubParams+1)-1 do
        begin

        if b = 0 then
          multiple_edit := edit
        else
          begin
          multiple_edit := TEdit(FindComponent(param + INPUT_DATA_COMPONENT_NAME_SURFIX + IntToStr(b)));
          value := value + INPUT_DATA_MULTIPLE_VALUES_SEPARATOR;
          end;

        if multiple_edit.Text = '' then
          begin
          value := '';
          Break;
          end
        else if EditParamTypes[edit.Tag].Numeric then
          value := value + StrToStrEx2(multiple_edit.Text, INPUT_DATA_DECIMAL_SEPARATOR)
        else
          value := value + multiple_edit.Text;

        end;

      // Zapis parametru
      if value <> '' then
        allopt.Add(INPUT_DATA_PARAM_CHAR + param + ' ' + value);

      end
    else if component is TComboBox then
      begin

      // Pole listy
      combobox := TComboBox(component);

      // Pozycja listy, pola specjalne
      if param = 'init_mag' then
        begin

        checkbox := TCheckBox(FindComponent(param + INPUT_DATA_COMPONENT_NAME_SURFIX + '1'));

        value := GetValueFromIndex(combobox.Tag, combobox.ItemIndex);

        if checkbox.Checked then
          value := '-' + value;

        end
      else
        value := GetValueFromIndex(combobox.Tag, combobox.ItemIndex);

      // Zapis parametru
      if value <> '' then
        allopt.Add(INPUT_DATA_PARAM_CHAR + param + ' ' + value);

      end
    else if component is TCheckBox then
      begin

      // Pole wyboru
      checkbox := TCheckBox(component);

      // Zapis parametru
      if checkbox.Checked then
        allopt.Add(INPUT_DATA_PARAM_CHAR + param);

      end;
    
    end;

// Zapisywanie do pliku
allopt.SaveToFile(FileName);

// Zwalnianie listy danych pliku
allopt.Free;

end;

// -----------------------------------------------------------------------------
procedure TSimulationEditForm.TAOEnergyMinimizationScrollBarChange(Sender: TObject);
begin
if TAOEnergyMinimizationScrollBar.Position <= TAOEnergyMinimizationScrollBar.Max-TAOEnergyMinimizationScrollBar.PageSize then
  TAOEnergyMinimizationScrollPanel.Top := -TAOEnergyMinimizationScrollBar.Position
else
  TAOEnergyMinimizationScrollPanel.Top := -(TAOEnergyMinimizationScrollBar.Max-TAOEnergyMinimizationScrollBar.PageSize);
end;

// -----------------------------------------------------------------------------
procedure TSimulationEditForm.FormCreate(Sender: TObject);
var
  i: Integer;
begin

// Tablice typow parametrow
SetLength(EditParamTypes, 4);

// Tekstowy
with EditParamTypes[0] do
  begin
  Numeric := False;
  SubParams := 0;
  end;

// Numeryczny
with EditParamTypes[1] do
  begin
  Numeric := True;
  SubParams := 0;
  end;

// Numeryczny, 2 skladowy
with EditParamTypes[2] do
  begin
  Numeric := True;
  SubParams := 1;
  end;

// Numeryczny, 3 skladowy
with EditParamTypes[3] do
  begin
  Numeric := True;
  SubParams := 2;
  end;

// Tablice typow parametrow
SetLength(ComboBoxParamTypes, 6);

// Standardowy
with ComboBoxParamTypes[0] do
  begin
  SetLength(Values, 32);
  for i := 0 to Length(Values)-1 do
    Values[i] := IntToStr(i);
  end;

// -mode
with ComboBoxParamTypes[1] do
  begin
  SetLength(Values, 5);
  Values[0] := '0';
  Values[1] := '1';
  Values[2] := '2';
  Values[3] := '3';
  Values[4] := '99';
  end;

// -hdemag_u1_ksp_type, -hdemag_u2_ksp_type
with ComboBoxParamTypes[2] do
  begin
  SetLength(Values, 3);
  Values[0] := 'gmres';
  Values[1] := 'cg';
  Values[2] := 'preonly';
  end;

// -pc_type, -sub_pc_type
with ComboBoxParamTypes[3] do
  begin
  SetLength(Values, 22);
  Values[0] := 'none';
  Values[1] := 'jacobi';
  Values[2] := 'pbjacobi';
  Values[3] := 'bjacobi';
  Values[4] := 'sor';
  Values[5] := 'lu';
  Values[6] := 'shell';
  Values[7] := 'mg';
  Values[8] := 'eisenstat';
  Values[9] := 'ilu';
  Values[10] := 'icc';
  Values[11] := 'cholesky';
  Values[12] := 'asm';
  Values[13] := 'sles';
  Values[14] := 'composite';
  Values[15] := 'redundant';
  Values[16] := 'nn';
  Values[17] := 'mat';
  Values[18] := 'milu';
  Values[19] := 'jacobic';
  Values[20] := 'multilevel';
  Values[21] := 'schur';
  end;  

// -tao_method
with ComboBoxParamTypes[4] do
  begin
  SetLength(Values, 13);
  Values[0] := 'tao_nls';
  Values[1] := 'tao_ntr';
  Values[2] := 'tao_lmvm';
  Values[3] := 'tao_cg_fr';
  Values[4] := 'tao_cg_pr';
  Values[5] := 'tao_cg_prp';
  Values[6] := 'tao_tron';
  Values[7] := 'tao_gpcg';
  Values[8] := 'tao_blmvm';
  Values[9] := 'tao_kt';
  Values[10] := 'tao_bqpip';
  Values[11] := 'tao_ssils';
  Values[12] := 'tao_ssfls';
  end;

// -ts_pvode_type
with ComboBoxParamTypes[5] do
  begin
  SetLength(Values, 2);
  Values[0] := 'bdf';
  Values[1] := 'adams';
  end;

// Przewijane panele
MagneticFieldsScrollBar.Max := MagneticFieldsScrollPanel.Height - MagneticFieldsPanel.Height + MagneticFieldsScrollBar.PageSize;
TAOEnergyMinimizationScrollBar.Max := TAOEnergyMinimizationScrollPanel.Height - TAOEnergyMinimizationPanel.Height + TAOEnergyMinimizationScrollBar.PageSize;
LGGTimeIntegrationScrollBar.Max := LGGTimeIntegrationScrollPanel.Height - LGGTimeIntegrationPanel.Height + LGGTimeIntegrationScrollBar.PageSize;

// Aktywna zakladka
PageControl.ActivePageIndex := 0;

end;

// -----------------------------------------------------------------------------
procedure TSimulationEditForm.FormDestroy(Sender: TObject);
var
  b: Byte;
begin

// Tablice typow parametrow
EditParamTypes := nil;

for b := 0 to Length(ComboBoxParamTypes)-1 do
  ComboBoxParamTypes[b].Values := nil;
ComboBoxParamTypes := nil;

end;

end.
